/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.compatibility.DeserializeConfig;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.ColumnSchema;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TableSchema {
    protected String tableName;
    protected List<IMeasurementSchema> measurementSchemas;
    protected List<ColumnCategory> columnCategories;
    protected boolean updatable = false;
    private Map<String, Integer> columnPosIndex;
    private Map<String, Integer> idColumnOrder;

    public TableSchema(String tableName) {
        this.tableName = tableName.toLowerCase();
        this.measurementSchemas = new ArrayList<IMeasurementSchema>();
        this.columnCategories = new ArrayList<ColumnCategory>();
        this.updatable = true;
    }

    public TableSchema(List<IMeasurementSchema> columnSchemas, List<ColumnCategory> columnCategories) {
        this.measurementSchemas = columnSchemas.stream().map(measurementSchema -> new MeasurementSchema(measurementSchema.getMeasurementName().toLowerCase(), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), measurementSchema.getProps())).collect(Collectors.toList());
        this.columnCategories = columnCategories;
        this.updatable = false;
    }

    public TableSchema(String tableName, List<IMeasurementSchema> columnSchemas, List<ColumnCategory> columnCategories) {
        this.tableName = tableName.toLowerCase();
        this.measurementSchemas = new ArrayList<IMeasurementSchema>(columnSchemas.size());
        this.columnPosIndex = new HashMap<String, Integer>(columnSchemas.size());
        for (int i = 0; i < columnSchemas.size(); ++i) {
            IMeasurementSchema columnSchema = columnSchemas.get(i);
            String measurementName = columnSchema.getMeasurementName().toLowerCase();
            this.measurementSchemas.add(new MeasurementSchema(measurementName, columnSchema.getType(), columnSchema.getEncodingType(), columnSchema.getCompressor(), columnSchema.getProps()));
            this.columnPosIndex.put(measurementName, i);
        }
        if (this.measurementSchemas.size() != this.columnPosIndex.size()) {
            throw new IllegalArgumentException("Each column name in the table should be unique(case insensitive).");
        }
        this.columnCategories = columnCategories;
        this.updatable = false;
    }

    public TableSchema(String tableName, List<String> columnNameList, List<TSDataType> dataTypeList, List<ColumnCategory> categoryList) {
        this.tableName = tableName.toLowerCase();
        this.measurementSchemas = new ArrayList<IMeasurementSchema>(columnNameList.size());
        this.columnPosIndex = new HashMap<String, Integer>(columnNameList.size());
        for (int i = 0; i < columnNameList.size(); ++i) {
            String columnName = columnNameList.get(i).toLowerCase();
            this.measurementSchemas.add(new MeasurementSchema(columnName, dataTypeList.get(i)));
            this.columnPosIndex.put(columnName, i);
        }
        if (columnNameList.size() != this.columnPosIndex.size()) {
            throw new IllegalArgumentException("Each column name in the table should be unique(case insensitive).");
        }
        this.columnCategories = categoryList;
        this.updatable = false;
    }

    @TsFileApi
    public TableSchema(String tableName, List<ColumnSchema> columnSchemaList) {
        this.tableName = tableName.toLowerCase();
        this.measurementSchemas = new ArrayList<IMeasurementSchema>(columnSchemaList.size());
        this.columnCategories = new ArrayList<ColumnCategory>(columnSchemaList.size());
        this.columnPosIndex = new HashMap<String, Integer>(columnSchemaList.size());
        for (int i = 0; i < columnSchemaList.size(); ++i) {
            ColumnSchema columnSchema = columnSchemaList.get(i);
            String columnName = columnSchema.getColumnName().toLowerCase();
            this.measurementSchemas.add(new MeasurementSchema(columnName, columnSchema.getDataType()));
            this.columnCategories.add(columnSchema.getColumnCategory());
            this.columnPosIndex.put(columnName, i);
        }
        if (columnSchemaList.size() != this.columnPosIndex.size()) {
            throw new IllegalArgumentException("Each column name in the table should be unique(case insensitive).");
        }
        this.updatable = false;
    }

    public Map<String, Integer> getColumnPosIndex() {
        if (this.columnPosIndex == null) {
            this.columnPosIndex = new HashMap<String, Integer>();
        }
        return this.columnPosIndex;
    }

    public Map<String, Integer> buildColumnPosIndex() {
        if (this.columnPosIndex == null) {
            this.columnPosIndex = new HashMap<String, Integer>();
        }
        if (this.columnPosIndex.size() >= this.measurementSchemas.size()) {
            return this.columnPosIndex;
        }
        for (int i = 0; i < this.measurementSchemas.size(); ++i) {
            IMeasurementSchema currentColumnSchema = this.measurementSchemas.get(i);
            this.columnPosIndex.putIfAbsent(currentColumnSchema.getMeasurementName(), i);
        }
        return this.columnPosIndex;
    }

    public Map<String, Integer> getIdColumnOrder() {
        if (this.idColumnOrder == null) {
            this.idColumnOrder = new HashMap<String, Integer>();
        }
        return this.idColumnOrder;
    }

    public int findColumnIndex(String columnName) {
        String lowerCaseColumnName = columnName.toLowerCase();
        return this.getColumnPosIndex().computeIfAbsent(lowerCaseColumnName, colName -> {
            for (int i = 0; i < this.measurementSchemas.size(); ++i) {
                if (!this.measurementSchemas.get(i).getMeasurementName().equals(lowerCaseColumnName)) continue;
                return i;
            }
            return -1;
        });
    }

    public int findIdColumnOrder(String columnName) {
        String lowerCaseColumnName = columnName.toLowerCase();
        return this.getIdColumnOrder().computeIfAbsent(lowerCaseColumnName, colName -> {
            int columnOrder = 0;
            for (int i = 0; i < this.measurementSchemas.size(); ++i) {
                if (this.measurementSchemas.get(i).getMeasurementName().equals(lowerCaseColumnName) && this.columnCategories.get(i) == ColumnCategory.TAG) {
                    return columnOrder;
                }
                if (this.columnCategories.get(i) != ColumnCategory.TAG) continue;
                ++columnOrder;
            }
            return -1;
        });
    }

    public IMeasurementSchema findColumnSchema(String columnName) {
        int columnIndex = this.findColumnIndex(columnName.toLowerCase());
        return columnIndex >= 0 ? this.measurementSchemas.get(columnIndex) : null;
    }

    public void update(ChunkGroupMetadata chunkGroupMetadata) {
        if (!this.updatable) {
            return;
        }
        for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
            if ("".equals(chunkMetadata.getMeasurementUid())) continue;
            int columnIndex = this.findColumnIndex(chunkMetadata.getMeasurementUid());
            if (columnIndex == -1) {
                this.measurementSchemas.add(chunkMetadata.toMeasurementSchema());
                this.columnCategories.add(ColumnCategory.FIELD);
                this.getColumnPosIndex().put(chunkMetadata.getMeasurementUid(), this.measurementSchemas.size() - 1);
                continue;
            }
            IMeasurementSchema originSchema = this.measurementSchemas.get(columnIndex);
            if (originSchema.getType() == chunkMetadata.getDataType()) continue;
            originSchema.setDataType(TSDataType.STRING);
        }
    }

    public List<IMeasurementSchema> getColumnSchemas() {
        return this.measurementSchemas;
    }

    public List<ColumnCategory> getColumnTypes() {
        return this.columnCategories;
    }

    public int serialize(OutputStream out) throws IOException {
        int cnt = 0;
        if (this.measurementSchemas != null) {
            cnt += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.measurementSchemas.size(), out);
            for (int i = 0; i < this.measurementSchemas.size(); ++i) {
                IMeasurementSchema columnSchema = this.measurementSchemas.get(i);
                ColumnCategory columnCategory = this.columnCategories.get(i);
                cnt += columnSchema.serializeTo(out);
                cnt += ReadWriteIOUtils.write(columnCategory.ordinal(), out);
            }
        } else {
            cnt += ReadWriteForEncodingUtils.writeUnsignedVarInt(0, out);
        }
        return cnt;
    }

    public int serializedSize() {
        try {
            return this.serialize(new ByteArrayOutputStream());
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static TableSchema deserialize(ByteBuffer buffer, DeserializeConfig context) {
        int columnCnt = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>(columnCnt);
        ArrayList<ColumnCategory> columnCategories = new ArrayList<ColumnCategory>();
        for (int i = 0; i < columnCnt; ++i) {
            MeasurementSchema measurementSchema = context.measurementSchemaBufferDeserializer.deserialize(buffer, context);
            measurementSchemas.add(measurementSchema);
            columnCategories.add(ColumnCategory.values()[buffer.getInt()]);
        }
        return new TableSchema(measurementSchemas, columnCategories);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName.toLowerCase();
    }

    public String toString() {
        return "TableSchema{tableName='" + this.tableName + '\'' + ", columnSchemas=" + this.measurementSchemas + ", columnTypes=" + this.columnCategories + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableSchema)) {
            return false;
        }
        TableSchema that = (TableSchema)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.measurementSchemas, that.measurementSchemas) && Objects.equals(this.columnCategories, that.columnCategories);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.measurementSchemas, this.columnCategories);
    }
}

