/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import org.apache.ratis.util.TraditionalBinaryPrefix;

public final class SizeInBytes {
    public static final SizeInBytes ZERO = SizeInBytes.valueOf(0L);
    public static final SizeInBytes ONE_KB = SizeInBytes.valueOf("1k");
    public static final SizeInBytes ONE_MB = SizeInBytes.valueOf("1m");
    private final long size;
    private final String input;
    private final String description;

    public static SizeInBytes valueOf(long size) {
        String s = String.valueOf(size);
        return new SizeInBytes(size, s, s);
    }

    public static SizeInBytes valueOf(long n, TraditionalBinaryPrefix prefix) {
        long size = Objects.requireNonNull(prefix, "prefix == null").toLong(n);
        String input = n + " " + prefix.getSymbol();
        String description = input + " (=" + size + ")";
        return new SizeInBytes(size, input, description);
    }

    public static SizeInBytes valueOf(String input) {
        long size;
        int last;
        String s = "b".equalsIgnoreCase((input = Objects.requireNonNull(input, "input == null").trim()).substring(last = input.length() - 1)) ? input.substring(0, last) : input;
        try {
            size = TraditionalBinaryPrefix.string2long(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse input " + input, e);
        }
        String description = input.equals(String.valueOf(size)) ? input : input + " (=" + size + ")";
        return new SizeInBytes(size, input, description);
    }

    private SizeInBytes(long size, String input, String description) {
        this.size = size;
        this.input = input;
        this.description = description;
    }

    public long getSize() {
        return this.size;
    }

    public int getSizeInt() {
        return Math.toIntExact(this.getSize());
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return this.description;
    }
}

