/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class AsyncOperationContext<R> {
    private final CompletableFuture<R> future = new CompletableFuture();
    private final OpcUaServer server;

    public AsyncOperationContext(OpcUaServer server) {
        this.server = server;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public CompletableFuture<R> getFuture() {
        return this.future;
    }

    public void success(R result) {
        this.future.complete(result);
    }

    public void failure(UaException failure) {
        this.future.completeExceptionally(failure);
    }

    public void failure(StatusCode statusCode) {
        this.failure(new UaException(statusCode));
    }

    public void failure(long statusCode) {
        this.failure(new StatusCode(statusCode));
    }
}

