/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TLoadSample;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeHeartbeatCache
extends BaseNodeCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeHeartbeatCache.class);
    private final AtomicReference<TLoadSample> latestLoadSample = new AtomicReference<TLoadSample>(new TLoadSample());

    public DataNodeHeartbeatCache(int dataNodeId) {
        super(dataNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateCurrentStatistics(boolean forceUpdate) {
        NodeStatus status;
        if (!forceUpdate && NodeStatus.Removing.equals((Object)this.getNodeStatus())) {
            return;
        }
        String statusReason = null;
        long currentNanoTime = System.nanoTime();
        List list = this.slidingWindow;
        synchronized (list) {
            NodeHeartbeatSample lastSample = (NodeHeartbeatSample)this.getLastSample();
            List<AbstractHeartbeatSample> heartbeatHistory = Collections.unmodifiableList(this.slidingWindow);
            if (lastSample != null && lastSample.isSetLoadSample()) {
                this.latestLoadSample.set(lastSample.getLoadSample());
            }
            if (lastSample == null) {
                status = NodeStatus.Unknown;
            } else if (!this.failureDetector.isAvailable(this.nodeId, heartbeatHistory)) {
                status = NodeStatus.Unknown;
            } else {
                status = lastSample.getStatus();
                statusReason = lastSample.getStatusReason();
            }
        }
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        this.currentStatistics.set(new NodeStatistics(currentNanoTime, status, statusReason, loadScore));
        if (forceUpdate) {
            LOGGER.debug("Force update NodeCache: status={}, currentNanoTime={}", (Object)status, (Object)currentNanoTime);
        }
    }

    public double getFreeDiskSpace() {
        return this.latestLoadSample.get().getFreeDiskSpace();
    }
}

