/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.ConfigNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginClassLoaderManager;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.pipe.plugin.GetPipePluginJarPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.CreatePipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.pipe.plugin.PipePluginTableResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePluginInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginInfo.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SNAPSHOT_FILE_NAME = "pipe_plugin_info.bin";
    private final ReentrantLock pipePluginInfoLock = new ReentrantLock();
    private final ConfigNodePipePluginMetaKeeper pipePluginMetaKeeper = new ConfigNodePipePluginMetaKeeper();
    private final PipePluginExecutableManager pipePluginExecutableManager = PipePluginExecutableManager.setupAndGetInstance((String)CONFIG_NODE_CONF.getPipeTemporaryLibDir(), (String)CONFIG_NODE_CONF.getPipeDir());
    private final PipePluginClassLoaderManager classLoaderManager = PipePluginClassLoaderManager.setupAndGetInstance((String)CONFIG_NODE_CONF.getPipeDir());

    public void acquirePipePluginInfoLock() {
        this.pipePluginInfoLock.lock();
    }

    public void releasePipePluginInfoLock() {
        this.pipePluginInfoLock.unlock();
    }

    public boolean validateBeforeCreatingPipePlugin(String pluginName, boolean isSetIfNotExistsCondition) {
        if (this.pipePluginMetaKeeper.containsPipePlugin(pluginName)) {
            if (isSetIfNotExistsCondition) {
                return true;
            }
            throw new PipeException(String.format("Failed to create PipePlugin [%s], the same name PipePlugin has been created", pluginName));
        }
        return false;
    }

    public boolean validateBeforeDroppingPipePlugin(String pluginName, boolean isSetIfExistsCondition) {
        if (!this.pipePluginMetaKeeper.containsPipePlugin(pluginName)) {
            if (isSetIfExistsCondition) {
                return true;
            }
            throw new PipeException(String.format("Failed to drop PipePlugin [%s], this PipePlugin has not been created", pluginName));
        }
        if (this.pipePluginMetaKeeper.getPipePluginMeta(pluginName).isBuiltin()) {
            throw new PipeException(String.format("Failed to drop PipePlugin [%s], the PipePlugin is a built-in PipePlugin", pluginName));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPipePluginExisted(String pipePluginName, boolean isTableModel) {
        this.acquirePipePluginInfoLock();
        try {
            boolean bl = this.pipePluginMetaKeeper.containsPipePlugin(pipePluginName) && this.pipePluginMetaKeeper.visibleUnder(pipePluginName, isTableModel);
            return bl;
        }
        finally {
            this.releasePipePluginInfoLock();
        }
    }

    public boolean isJarNeededToBeSavedWhenCreatingPipePlugin(String jarName) {
        return !this.pipePluginMetaKeeper.containsJar(jarName);
    }

    public void checkPipePluginExistence(Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) {
        PipeParameters extractorParameters = new PipeParameters(extractorAttributes);
        String extractorPluginName = extractorParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName());
        if (!this.pipePluginMetaKeeper.containsPipePlugin(extractorPluginName)) {
            String exceptionMessage = String.format("Failed to create or alter pipe, the pipe extractor plugin %s does not exist", extractorPluginName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeParameters processorParameters = new PipeParameters(processorAttributes);
        String processorPluginName = processorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName());
        if (!this.pipePluginMetaKeeper.containsPipePlugin(processorPluginName)) {
            String exceptionMessage = String.format("Failed to create or alter pipe, the pipe processor plugin %s does not exist", processorPluginName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        String connectorPluginName = connectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName());
        if (!this.pipePluginMetaKeeper.containsPipePlugin(connectorPluginName)) {
            String exceptionMessage = String.format("Failed to create or alter pipe, the pipe connector plugin %s does not exist", connectorPluginName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public TSStatus createPipePlugin(CreatePipePluginPlan createPipePluginPlan) {
        try {
            PipePluginMeta pipePluginMeta = createPipePluginPlan.getPipePluginMeta();
            String pluginName = pipePluginMeta.getPluginName();
            this.dropPipePlugin(new DropPipePluginPlan(pluginName));
            this.pipePluginMetaKeeper.addPipePluginMeta(pluginName, pipePluginMeta);
            this.pipePluginMetaKeeper.addJarNameAndMd5(pipePluginMeta.getJarName(), pipePluginMeta.getJarMD5());
            if (createPipePluginPlan.getJarFile() != null) {
                this.pipePluginExecutableManager.savePluginToInstallDir(ByteBuffer.wrap(createPipePluginPlan.getJarFile().getValues()), pluginName, pipePluginMeta.getJarName());
                String pluginDirPath = this.pipePluginExecutableManager.getPluginsDirPath(pluginName);
                PipePluginClassLoader pipePluginClassLoader = this.classLoaderManager.createPipePluginClassLoader(pluginDirPath);
                try {
                    Class<?> pluginClass = Class.forName(pipePluginMeta.getClassName(), true, (ClassLoader)pipePluginClassLoader);
                    this.pipePluginMetaKeeper.addPipePluginVisibility(pluginName, VisibilityUtils.calculateFromPluginClass(pluginClass));
                    this.classLoaderManager.addPluginAndClassLoader(pluginName, pipePluginClassLoader);
                }
                catch (Exception e) {
                    try {
                        pipePluginClassLoader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to execute createPipePlugin(%s) on config nodes, because of %s", createPipePluginPlan.getPipePluginMeta().getPluginName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    public TSStatus dropPipePlugin(DropPipePluginPlan dropPipePluginPlan) {
        String pluginName = dropPipePluginPlan.getPluginName();
        if (this.pipePluginMetaKeeper.containsPipePlugin(pluginName)) {
            String jarName = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName).getJarName();
            this.pipePluginMetaKeeper.removeJarNameAndMd5IfPossible(jarName);
            this.pipePluginMetaKeeper.removePipePluginMeta(pluginName);
            this.pipePluginMetaKeeper.removePipePluginVisibility(pluginName);
            try {
                this.pipePluginExecutableManager.removePluginFileUnderLibRoot(pluginName, jarName);
                this.classLoaderManager.removePluginClassLoader(pluginName);
            }
            catch (IOException e) {
                String errorMessage = String.format("Failed to execute dropPipePlugin(%s) on config nodes, because of %s", pluginName, e);
                LOGGER.warn(errorMessage, (Throwable)e);
                return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
            }
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public DataSet showPipePlugins() {
        return new PipePluginTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), StreamSupport.stream(this.pipePluginMetaKeeper.getAllPipePluginMeta().spliterator(), false).collect(Collectors.toList()), this.pipePluginMetaKeeper.getPipePluginNameToVisibilityMap());
    }

    public JarResp getPipePluginJar(GetPipePluginJarPlan getPipePluginJarPlan) {
        try {
            ArrayList<ByteBuffer> jarList = new ArrayList<ByteBuffer>();
            PipePluginExecutableManager manager = PipePluginExecutableManager.getInstance();
            for (String jarName : getPipePluginJarPlan.getJarNames()) {
                String pluginName = this.pipePluginMetaKeeper.getPluginNameByJarName(jarName);
                if (pluginName == null) {
                    throw new PipeException(String.format("%s does not exist", jarName));
                }
                String jarPath = manager.getPluginInstallPathV2(pluginName, jarName);
                boolean isJarExistedInV2Dir = Files.exists(Paths.get(jarPath, new String[0]), new LinkOption[0]);
                if (!isJarExistedInV2Dir) {
                    jarPath = manager.getPluginInstallPathV1(jarName);
                }
                if (!Files.exists(Paths.get(jarPath, new String[0]), new LinkOption[0])) {
                    throw new PipeException(String.format("%s does not exist", jarName));
                }
                ByteBuffer byteBuffer = ExecutableManager.transferToBytebuffer((String)jarPath);
                if (!isJarExistedInV2Dir) {
                    this.pipePluginExecutableManager.savePluginToInstallDir(byteBuffer.duplicate(), pluginName, jarName);
                }
                jarList.add(byteBuffer);
            }
            return new JarResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), jarList);
        }
        catch (Exception e) {
            LOGGER.error("Get PipePlugin_Jar failed", (Throwable)e);
            return new JarResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage("Get PipePlugin_Jar failed, because " + e.getMessage()), Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.acquirePipePluginInfoLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (snapshotFile.exists() && snapshotFile.isFile()) {
                LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.pipePluginMetaKeeper.processTakeSnapshot((OutputStream)fileOutputStream);
                fileOutputStream.getFD().sync();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releasePipePluginInfoLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.acquirePipePluginInfoLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (!snapshotFile.exists() || !snapshotFile.isFile()) {
                LOGGER.error("Failed to load snapshot, snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                this.pipePluginMetaKeeper.processLoadSnapshot((InputStream)fileInputStream);
            }
            for (PipePluginMeta pipePluginMeta : this.pipePluginMetaKeeper.getAllPipePluginMeta()) {
                if (pipePluginMeta.isBuiltin()) continue;
                String pluginName = pipePluginMeta.getPluginName();
                try {
                    String pluginDirPath = this.pipePluginExecutableManager.getPluginsDirPath(pluginName);
                    PipePluginClassLoader pipePluginClassLoader = this.classLoaderManager.createPipePluginClassLoader(pluginDirPath);
                    try {
                        Class<?> pluginClass = Class.forName(pipePluginMeta.getClassName(), true, (ClassLoader)pipePluginClassLoader);
                        this.pipePluginMetaKeeper.addPipePluginVisibility(pluginName, VisibilityUtils.calculateFromPluginClass(pluginClass));
                        this.classLoaderManager.addPluginAndClassLoader(pluginName, pipePluginClassLoader);
                    }
                    catch (Exception e) {
                        try {
                            pipePluginClassLoader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load plugin class for plugin [{}] when loading snapshot [{}] ", new Object[]{pluginName, snapshotFile.getAbsolutePath(), e});
                }
            }
        }
        finally {
            this.releasePipePluginInfoLock();
        }
    }

    public int hashCode() {
        return Objects.hash(this.pipePluginMetaKeeper, this.pipePluginExecutableManager);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PipePluginInfo other = (PipePluginInfo)obj;
        return Objects.equals(this.pipePluginExecutableManager, other.pipePluginExecutableManager) && Objects.equals(this.pipePluginMetaKeeper, other.pipePluginMetaKeeper);
    }

    public String toString() {
        return "PipePluginInfo [pipePluginMetaKeeper=" + this.pipePluginMetaKeeper + ", pipePluginExecutableManager=" + this.pipePluginExecutableManager + "]";
    }
}

