/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.consensuspipe;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.config.PipeConsensusConfig;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeDispatcher;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeSelector;

public class ConsensusPipeManager {
    private static final String CONSENSUS_EXTRACTOR_INCLUSION_VALUE = "data";
    private final PipeConsensusConfig.Pipe config;
    private final PipeConsensusConfig.ReplicateMode replicateMode;
    private final ConsensusPipeDispatcher dispatcher;
    private final ConsensusPipeSelector selector;

    public ConsensusPipeManager(PipeConsensusConfig.Pipe config, PipeConsensusConfig.ReplicateMode replicateMode) {
        this.config = config;
        this.replicateMode = replicateMode;
        this.dispatcher = config.getConsensusPipeDispatcher();
        this.selector = config.getConsensusPipeSelector();
    }

    public void createConsensusPipe(Peer senderPeer, Peer receiverPeer) throws Exception {
        ConsensusPipeName consensusPipeName = new ConsensusPipeName(senderPeer, receiverPeer);
        Triple<ImmutableMap<String, String>, ImmutableMap<String, String>, ImmutableMap<String, String>> params = this.buildPipeParams(senderPeer, receiverPeer);
        this.dispatcher.createPipe(consensusPipeName.toString(), (Map)params.getLeft(), (Map)params.getMiddle(), (Map)params.getRight(), false);
    }

    public void createConsensusPipe(Peer senderPeer, Peer receiverPeer, boolean needManuallyStart) throws Exception {
        ConsensusPipeName consensusPipeName = new ConsensusPipeName(senderPeer, receiverPeer);
        Triple<ImmutableMap<String, String>, ImmutableMap<String, String>, ImmutableMap<String, String>> params = this.buildPipeParams(senderPeer, receiverPeer);
        this.dispatcher.createPipe(consensusPipeName.toString(), (Map)params.getLeft(), (Map)params.getMiddle(), (Map)params.getRight(), needManuallyStart);
    }

    public Triple<ImmutableMap<String, String>, ImmutableMap<String, String>, ImmutableMap<String, String>> buildPipeParams(Peer senderPeer, Peer receiverPeer) {
        ConsensusPipeName consensusPipeName = new ConsensusPipeName(senderPeer, receiverPeer);
        return new ImmutableTriple((Object)ImmutableMap.builder().put((Object)"extractor", (Object)this.config.getExtractorPluginName()).put((Object)"extractor.inclusion", (Object)CONSENSUS_EXTRACTOR_INCLUSION_VALUE).put((Object)"extractor.consensus.group-id", (Object)consensusPipeName.getConsensusGroupId().toString()).put((Object)"extractor.consensus.sender-dn-id", (Object)String.valueOf(consensusPipeName.getSenderDataNodeId())).put((Object)"extractor.consensus.receiver-dn-id", (Object)String.valueOf(consensusPipeName.getReceiverDataNodeId())).put((Object)"extractor.realtime.mode", (Object)this.replicateMode.getValue()).put((Object)"extractor.capture.table", (Object)String.valueOf(true)).put((Object)"extractor.capture.tree", (Object)String.valueOf(true)).put((Object)"extractor.user", (Object)CommonDescriptor.getInstance().getConfig().getAdminName()).build(), (Object)ImmutableMap.builder().put((Object)"processor", (Object)this.config.getProcessorPluginName()).build(), (Object)ImmutableMap.builder().put((Object)"connector", (Object)this.config.getConnectorPluginName()).put((Object)"connector.consensus.group-id", (Object)String.valueOf(consensusPipeName.getConsensusGroupId().getId())).put((Object)"connector.consensus.pipe-name", (Object)consensusPipeName.toString()).put((Object)"connector.ip", (Object)receiverPeer.getEndpoint().ip).put((Object)"connector.port", (Object)String.valueOf(receiverPeer.getEndpoint().port)).put((Object)"connector.parallel.tasks", (Object)String.valueOf(1)).put((Object)"connector.realtime-first", (Object)String.valueOf(false)).build());
    }

    public void dropConsensusPipe(Peer senderPeer, Peer receiverPeer) throws Exception {
        ConsensusPipeName consensusPipeName = new ConsensusPipeName(senderPeer, receiverPeer);
        this.dispatcher.dropPipe(consensusPipeName);
    }

    public void updateConsensusPipe(ConsensusPipeName consensusPipeName, PipeStatus pipeStatus) throws Exception {
        if (PipeStatus.RUNNING.equals((Object)pipeStatus)) {
            this.dispatcher.startPipe(consensusPipeName.toString());
        } else if (PipeStatus.STOPPED.equals((Object)pipeStatus)) {
            this.dispatcher.stopPipe(consensusPipeName.toString());
        } else if (PipeStatus.DROPPED.equals((Object)pipeStatus)) {
            this.dispatcher.dropPipe(consensusPipeName);
        } else {
            throw new IllegalArgumentException("Unsupported pipe status: " + pipeStatus);
        }
    }

    public Map<ConsensusPipeName, PipeStatus> getAllConsensusPipe() {
        return this.selector.getAllConsensusPipe();
    }
}

