/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.async;

import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataNodeExternalServiceClient
extends IDataNodeRPCService.AsyncClient
implements ThriftClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDataNodeExternalServiceClient.class);
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncDataNodeExternalServiceClient> clientManager;

    public AsyncDataNodeExternalServiceClient(ThriftClientProperty property, TEndPoint endpoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncDataNodeExternalServiceClient> clientManager) throws IOException {
        super(property.getProtocolFactory(), tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)property.getConnectionTimeoutMs()));
        this.setTimeout(property.getConnectionTimeoutMs());
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    @TestOnly
    public TEndPoint getTEndpoint() {
        return this.endpoint;
    }

    @TestOnly
    public ClientManager<TEndPoint, AsyncDataNodeExternalServiceClient> getClientManager() {
        return this.clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException(e, this);
        this.returnSelf();
    }

    @Override
    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception("This client has been invalidated"));
        }
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    private void returnSelf() {
        this.clientManager.returnClient(this.endpoint, this);
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            if (this.printLogWhenEncounterException) {
                logger.error("Unexpected exception occurs in {}, error msg is {}", (Object)this, (Object)ExceptionUtils.getRootCause((Throwable)e).toString());
            }
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncDataNodeInternalServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncDataNodeExternalServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncDataNodeExternalServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncDataNodeExternalServiceClient> pooledObject) {
            ((AsyncDataNodeExternalServiceClient)pooledObject.getObject()).close();
        }

        public PooledObject<AsyncDataNodeExternalServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncDataNodeExternalServiceClient(this.thriftClientProperty, endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncDataNodeExternalServiceClient> pooledObject) {
            return ((AsyncDataNodeExternalServiceClient)pooledObject.getObject()).isReady();
        }
    }
}

