/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.compressor;

import com.github.luben.zstd.Zstd;
import java.io.IOException;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeCompressor;

public class PipeZSTDCompressor
extends PipeCompressor {
    private final int compressionLevel;

    public PipeZSTDCompressor(int compressionLevel) {
        super(PipeCompressor.PipeCompressionType.ZSTD);
        this.compressionLevel = compressionLevel;
    }

    @Override
    public byte[] compress(byte[] data) throws IOException {
        return Zstd.compress((byte[])data, (int)this.compressionLevel);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return Zstd.decompress((byte[])byteArray, (int)((int)Zstd.decompressedSize((byte[])byteArray, (int)0, (int)byteArray.length)));
    }

    @Override
    public byte[] decompress(byte[] byteArray, int decompressedLength) {
        return Zstd.decompress((byte[])byteArray, (int)decompressedLength);
    }
}

