/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational.tvf;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.WindowTVFUtils;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFTypeMismatchException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgumentChecker;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class VariationTableFunction
implements TableFunction {
    private static final String DATA_PARAMETER_NAME = "DATA";
    private static final String COL_PARAMETER_NAME = "COL";
    private static final String DELTA_PARAMETER_NAME = "DELTA";
    private static final String IGNORE_NULL_PARAMETER_NAME = "IGNORE_NULL";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name(DATA_PARAMETER_NAME).passThroughColumns().build(), ScalarParameterSpecification.builder().name(COL_PARAMETER_NAME).type(Type.STRING).build(), ScalarParameterSpecification.builder().name(DELTA_PARAMETER_NAME).type(Type.DOUBLE).defaultValue((Object)0.0).addChecker(ScalarArgumentChecker.NON_NEGATIVE_DOUBLE_CHECKER).build(), ScalarParameterSpecification.builder().name(IGNORE_NULL_PARAMETER_NAME).type(Type.BOOLEAN).defaultValue((Object)true).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        int requiredIndex;
        TableArgument tableArgument = (TableArgument)arguments.get(DATA_PARAMETER_NAME);
        String expectedFieldName = (String)((ScalarArgument)arguments.get(COL_PARAMETER_NAME)).getValue();
        double delta = (Double)((ScalarArgument)arguments.get(DELTA_PARAMETER_NAME)).getValue();
        try {
            requiredIndex = WindowTVFUtils.findColumnIndex(tableArgument, expectedFieldName, (Set<Type>)(delta == 0.0 ? ImmutableSet.copyOf((Collection)Type.allTypes()) : ImmutableSet.copyOf((Collection)Type.numericTypes())));
        }
        catch (UDFTypeMismatchException e) {
            throw new UDFTypeMismatchException(e.getMessage() + " The column type must be numeric if DELTA is not 0.", (Throwable)e);
        }
        DescribedSchema properColumnSchema = new DescribedSchema.Builder().addField("window_index", Type.INT64).build();
        MapTableFunctionHandle handle = new MapTableFunctionHandle.Builder().addProperty(DELTA_PARAMETER_NAME, (Object)delta).addProperty(IGNORE_NULL_PARAMETER_NAME, ((ScalarArgument)arguments.get(IGNORE_NULL_PARAMETER_NAME)).getValue()).build();
        return TableFunctionAnalysis.builder().properColumnSchema(properColumnSchema).requireRecordSnapshot(false).requiredColumns(DATA_PARAMETER_NAME, Collections.singletonList(requiredIndex)).handle((TableFunctionHandle)handle).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        final double delta = (Double)((MapTableFunctionHandle)tableFunctionHandle).getProperty(DELTA_PARAMETER_NAME);
        final boolean ignoreNull = (Boolean)((MapTableFunctionHandle)tableFunctionHandle).getProperty(IGNORE_NULL_PARAMETER_NAME);
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return delta == 0.0 ? new EquivalentVariationDataProcessor(ignoreNull) : new NonEquivalentVariationDataProcessor(delta, ignoreNull);
            }
        };
    }

    private static abstract class VariationDataProcessor
    implements TableFunctionDataProcessor {
        protected final boolean ignoreNull;
        protected long currentStartIndex = 0L;
        protected long curIndex = 0L;
        private long windowIndex = 0L;

        public VariationDataProcessor(boolean ignoreNull) {
            this.ignoreNull = ignoreNull;
        }

        abstract void resetBaseValue(Record var1);

        abstract boolean isCurrentBaseValueIsNull();

        void resetBaseValueIfNull(Record input) {
            if (this.isCurrentBaseValueIsNull()) {
                this.resetBaseValue(input);
            }
        }

        boolean isNewGroup(Record input) {
            if (input.isNull(0)) {
                if (this.isCurrentBaseValueIsNull()) {
                    return false;
                }
                return !this.ignoreNull;
            }
            if (this.isCurrentBaseValueIsNull()) {
                return !this.ignoreNull;
            }
            return this.outOfBound(input);
        }

        abstract boolean outOfBound(Record var1);

        public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            if (this.curIndex == 0L) {
                this.resetBaseValue(input);
            } else if (this.isNewGroup(input)) {
                this.outputWindow(properColumnBuilders, passThroughIndexBuilder, input);
            } else {
                this.resetBaseValueIfNull(input);
            }
            ++this.curIndex;
        }

        public void finish(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            this.outputWindow(properColumnBuilders, passThroughIndexBuilder, null);
        }

        protected void outputWindow(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder, Record input) {
            for (long i = this.currentStartIndex; i < this.curIndex; ++i) {
                properColumnBuilders.get(0).writeLong(this.windowIndex);
                passThroughIndexBuilder.writeLong(i);
            }
            if (this.curIndex > this.currentStartIndex) {
                ++this.windowIndex;
                this.currentStartIndex = this.curIndex;
                if (input != null) {
                    this.resetBaseValue(input);
                }
            }
        }
    }

    private static class NonEquivalentVariationDataProcessor
    extends VariationDataProcessor {
        private final double gap;
        private double baseValue = 0.0;
        private boolean baseValueIsNull = true;

        public NonEquivalentVariationDataProcessor(double delta, boolean ignoreNull) {
            super(ignoreNull);
            this.gap = delta;
        }

        @Override
        void resetBaseValue(Record input) {
            if (input.isNull(0)) {
                this.baseValueIsNull = true;
            } else {
                this.baseValueIsNull = false;
                this.baseValue = input.getDouble(0);
            }
        }

        @Override
        boolean isCurrentBaseValueIsNull() {
            return this.baseValueIsNull;
        }

        @Override
        boolean outOfBound(Record input) {
            if (this.isCurrentBaseValueIsNull()) {
                throw new IllegalStateException("When comparing, base value should never be null");
            }
            return Math.abs(input.getDouble(0) - this.baseValue) > this.gap;
        }
    }

    private static class EquivalentVariationDataProcessor
    extends VariationDataProcessor {
        protected Object baseValue = null;

        public EquivalentVariationDataProcessor(boolean ignoreNull) {
            super(ignoreNull);
        }

        @Override
        void resetBaseValue(Record input) {
            this.baseValue = input.isNull(0) ? null : input.getObject(0);
        }

        @Override
        boolean isCurrentBaseValueIsNull() {
            return this.baseValue == null;
        }

        @Override
        boolean outOfBound(Record input) {
            if (this.isCurrentBaseValueIsNull()) {
                throw new IllegalStateException("When comparing, base value should never be null");
            }
            return !input.getObject(0).equals(this.baseValue);
        }
    }
}

