/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.query;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.TsFileInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.query.TsFileInsertionEventQueryParserTabletIterator;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileReader;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.expression.IExpression;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionEventQueryParser
extends TsFileInsertionEventParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionEventQueryParser.class);
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final TsFileReader tsFileReader;
    private final Iterator<Map.Entry<IDeviceID, List<String>>> deviceMeasurementsMapIterator;
    private final Map<IDeviceID, Boolean> deviceIsAlignedMap;
    private final Map<String, TSDataType> measurementDataTypeMap;

    @TestOnly
    public TsFileInsertionEventQueryParser(File tsFile, TreePattern pattern, long startTime, long endTime, PipeInsertionEvent sourceEvent) throws IOException {
        this(null, 0L, tsFile, pattern, startTime, endTime, null, sourceEvent);
    }

    public TsFileInsertionEventQueryParser(String pipeName, long creationTime, File tsFile, TreePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, PipeInsertionEvent sourceEvent) throws IOException {
        this(pipeName, creationTime, tsFile, pattern, startTime, endTime, pipeTaskMeta, sourceEvent, null);
    }

    public TsFileInsertionEventQueryParser(String pipeName, long creationTime, File tsFile, TreePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, PipeInsertionEvent sourceEvent, Map<IDeviceID, Boolean> deviceIsAlignedMap) throws IOException {
        super(pipeName, creationTime, pattern, null, startTime, endTime, pipeTaskMeta, sourceEvent);
        try {
            Map<IDeviceID, List<String>> deviceMeasurementsMap;
            PipeTsFileResourceManager tsFileResourceManager = PipeDataNodeResourceManager.tsfile();
            long memoryRequiredInBytes = PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes();
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);
            this.tsFileReader = new TsFileReader(this.tsFileSequenceReader);
            if (tsFileResourceManager.cacheObjectsIfAbsent(tsFile)) {
                this.deviceIsAlignedMap = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap : tsFileResourceManager.getDeviceIsAlignedMapFromCache(tsFile, true);
                this.measurementDataTypeMap = tsFileResourceManager.getMeasurementDataTypeMapFromCache(tsFile);
                deviceMeasurementsMap = tsFileResourceManager.getDeviceMeasurementsMapFromCache(tsFile);
            } else {
                Set<IDeviceID> devices;
                if (Objects.isNull(deviceIsAlignedMap)) {
                    this.deviceIsAlignedMap = this.readDeviceIsAlignedMap();
                    memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap);
                    devices = this.filterDevicesByPattern(this.deviceIsAlignedMap.keySet());
                } else {
                    this.deviceIsAlignedMap = deviceIsAlignedMap;
                    devices = deviceIsAlignedMap.keySet();
                }
                this.measurementDataTypeMap = this.readFilteredFullPathDataTypeMap(devices);
                memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfStr2TSDataType(this.measurementDataTypeMap);
                deviceMeasurementsMap = this.readFilteredDeviceMeasurementsMap(devices);
                memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceID2StrList(deviceMeasurementsMap);
            }
            this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocate(memoryRequiredInBytes);
            this.deviceMeasurementsMapIterator = this.filterDeviceMeasurementsMapByPattern(deviceMeasurementsMap).entrySet().iterator();
            this.tsFileSequenceReader.clearCachedDeviceMetadata();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Map<IDeviceID, List<String>> filterDeviceMeasurementsMapByPattern(Map<IDeviceID, List<String>> originalDeviceMeasurementsMap) {
        HashMap<IDeviceID, List<String>> filteredDeviceMeasurementsMap = new HashMap<IDeviceID, List<String>>();
        for (Map.Entry<IDeviceID, List<String>> entry : originalDeviceMeasurementsMap.entrySet()) {
            IDeviceID deviceId = entry.getKey();
            if (Objects.isNull(this.treePattern) || this.treePattern.isRoot() || this.treePattern.coversDevice(deviceId)) {
                if (entry.getValue().isEmpty()) continue;
                filteredDeviceMeasurementsMap.put(deviceId, entry.getValue());
                continue;
            }
            if (!this.treePattern.mayOverlapWithDevice(deviceId)) continue;
            ArrayList<String> filteredMeasurements = new ArrayList<String>();
            for (String measurement : entry.getValue()) {
                if (!this.treePattern.matchesMeasurement(deviceId, measurement)) continue;
                filteredMeasurements.add(measurement);
            }
            if (filteredMeasurements.isEmpty()) continue;
            filteredDeviceMeasurementsMap.put(deviceId, filteredMeasurements);
        }
        return filteredDeviceMeasurementsMap;
    }

    private Map<IDeviceID, Boolean> readDeviceIsAlignedMap() throws IOException {
        HashMap<IDeviceID, Boolean> deviceIsAlignedResultMap = new HashMap<IDeviceID, Boolean>();
        TsFileDeviceIterator deviceIsAlignedIterator = this.tsFileSequenceReader.getAllDevicesIteratorWithIsAligned();
        while (deviceIsAlignedIterator.hasNext()) {
            Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
            deviceIsAlignedResultMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
        }
        return deviceIsAlignedResultMap;
    }

    private Set<IDeviceID> filterDevicesByPattern(Set<IDeviceID> devices) {
        if (Objects.isNull(this.treePattern) || this.treePattern.isRoot()) {
            return devices;
        }
        HashSet<IDeviceID> filteredDevices = new HashSet<IDeviceID>();
        for (IDeviceID device : devices) {
            if (!this.treePattern.coversDevice(device) && !this.treePattern.mayOverlapWithDevice(device)) continue;
            filteredDevices.add(device);
        }
        return filteredDevices;
    }

    private Map<String, TSDataType> readFilteredFullPathDataTypeMap(Set<IDeviceID> devices) throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (IDeviceID device : devices) {
            this.tsFileSequenceReader.readDeviceMetadata(device).values().forEach(timeseriesMetadata -> result.put(device.toString() + "." + timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTsDataType()));
        }
        return result;
    }

    private Map<IDeviceID, List<String>> readFilteredDeviceMeasurementsMap(Set<IDeviceID> devices) throws IOException {
        HashMap<IDeviceID, List<String>> result = new HashMap<IDeviceID, List<String>>();
        for (IDeviceID device : devices) {
            this.tsFileSequenceReader.readDeviceMetadata(device).values().forEach(timeseriesMetadata -> result.computeIfAbsent(device, d -> new ArrayList()).add(timeseriesMetadata.getMeasurementId()));
        }
        return result;
    }

    @Override
    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        return () -> new Iterator<TabletInsertionEvent>(){
            private TsFileInsertionEventQueryParserTabletIterator tabletIterator = null;

            @Override
            public boolean hasNext() {
                while (this.tabletIterator == null || !this.tabletIterator.hasNext()) {
                    if (!TsFileInsertionEventQueryParser.this.deviceMeasurementsMapIterator.hasNext()) {
                        TsFileInsertionEventQueryParser.this.close();
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)TsFileInsertionEventQueryParser.this.deviceMeasurementsMapIterator.next();
                    try {
                        this.tabletIterator = new TsFileInsertionEventQueryParserTabletIterator(TsFileInsertionEventQueryParser.this.tsFileReader, TsFileInsertionEventQueryParser.this.measurementDataTypeMap, (IDeviceID)entry.getKey(), (List)entry.getValue(), (IExpression)TsFileInsertionEventQueryParser.this.timeFilterExpression, TsFileInsertionEventQueryParser.this.allocatedMemoryBlockForTablet);
                    }
                    catch (Exception e) {
                        TsFileInsertionEventQueryParser.this.close();
                        throw new PipeException("failed to create TsFileInsertionDataTabletIterator", (Throwable)e);
                    }
                }
                return true;
            }

            @Override
            public TabletInsertionEvent next() {
                PipeRawTabletInsertionEvent next;
                if (!this.hasNext()) {
                    TsFileInsertionEventQueryParser.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = this.tabletIterator.next();
                boolean isAligned = TsFileInsertionEventQueryParser.this.deviceIsAlignedMap.getOrDefault(IDeviceID.Factory.DEFAULT_FACTORY.create(tablet.getDeviceId()), false);
                if (!this.hasNext()) {
                    next = TsFileInsertionEventQueryParser.this.sourceEvent == null ? new PipeRawTabletInsertionEvent(null, null, null, null, tablet, isAligned, null, 0L, TsFileInsertionEventQueryParser.this.pipeTaskMeta, TsFileInsertionEventQueryParser.this.sourceEvent, true) : new PipeRawTabletInsertionEvent(TsFileInsertionEventQueryParser.this.sourceEvent.getRawIsTableModelEvent(), TsFileInsertionEventQueryParser.this.sourceEvent.getSourceDatabaseNameFromDataRegion(), TsFileInsertionEventQueryParser.this.sourceEvent.getRawTableModelDataBase(), TsFileInsertionEventQueryParser.this.sourceEvent.getRawTreeModelDataBase(), tablet, isAligned, TsFileInsertionEventQueryParser.this.sourceEvent.getPipeName(), TsFileInsertionEventQueryParser.this.sourceEvent.getCreationTime(), TsFileInsertionEventQueryParser.this.pipeTaskMeta, TsFileInsertionEventQueryParser.this.sourceEvent, true);
                    TsFileInsertionEventQueryParser.this.close();
                } else {
                    next = TsFileInsertionEventQueryParser.this.sourceEvent == null ? new PipeRawTabletInsertionEvent(null, null, null, null, tablet, isAligned, null, 0L, TsFileInsertionEventQueryParser.this.pipeTaskMeta, TsFileInsertionEventQueryParser.this.sourceEvent, false) : new PipeRawTabletInsertionEvent(TsFileInsertionEventQueryParser.this.sourceEvent.getRawIsTableModelEvent(), TsFileInsertionEventQueryParser.this.sourceEvent.getSourceDatabaseNameFromDataRegion(), TsFileInsertionEventQueryParser.this.sourceEvent.getRawTableModelDataBase(), TsFileInsertionEventQueryParser.this.sourceEvent.getRawTreeModelDataBase(), tablet, isAligned, TsFileInsertionEventQueryParser.this.sourceEvent.getPipeName(), TsFileInsertionEventQueryParser.this.sourceEvent.getCreationTime(), TsFileInsertionEventQueryParser.this.pipeTaskMeta, TsFileInsertionEventQueryParser.this.sourceEvent, false);
                }
                return next;
            }
        };
    }

    @Override
    public void close() {
        try {
            if (this.tsFileReader != null) {
                this.tsFileReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileReader", (Throwable)e);
        }
        super.close();
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
        }
    }
}

