/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.exchange.receiver;

import org.apache.iotdb.commons.pipe.receiver.IoTDBReceiver;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.db.pipe.processor.twostage.combiner.PipeCombineHandlerManager;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.CombineRequest;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.FetchCombineResultRequest;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.RequestType;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStageAggregateReceiver
implements IoTDBReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwoStageAggregateReceiver.class);

    public IoTDBSinkRequestVersion getVersion() {
        return IoTDBSinkRequestVersion.VERSION_2;
    }

    public TPipeTransferResp receive(TPipeTransferReq req) {
        try {
            short rawRequestType = req.getType();
            if (RequestType.isValidatedRequestType(rawRequestType)) {
                switch (RequestType.valueOf(rawRequestType)) {
                    case COMBINE: {
                        return PipeCombineHandlerManager.getInstance().handle(CombineRequest.fromTPipeTransferReq(req));
                    }
                    case FETCH_COMBINE_RESULT: {
                        return PipeCombineHandlerManager.getInstance().handle(FetchCombineResultRequest.fromTPipeTransferReq(req));
                    }
                }
            }
            LOGGER.warn("Unknown request type {}: {}.", (Object)rawRequestType, (Object)req);
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("Unknown request type %s.", rawRequestType)));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when receiving request: {}.", (Object)req, (Object)e);
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)String.format("Error occurs when receiving request: %s.", e.getMessage())));
        }
    }

    public void handleExit() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Two stage aggregate receiver is exiting.");
        }
    }
}

