/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.schemaregion;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.CreateOrUpdateTableDeviceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeUpdateNode;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;

public class PipePlanTablePrivilegeParseVisitor
extends PlanVisitor<Optional<PlanNode>, String> {
    @Override
    public Optional<PlanNode> visitPlan(PlanNode node, String userName) {
        return Optional.of(node);
    }

    @Override
    public Optional<PlanNode> visitCreateOrUpdateTableDevice(CreateOrUpdateTableDeviceNode node, String userName) {
        return Coordinator.getInstance().getAccessControl().checkCanSelectFromTable4Pipe(userName, new QualifiedObjectName(node.getDatabase(), node.getTableName())) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitTableDeviceAttributeUpdate(TableDeviceAttributeUpdateNode node, String userName) {
        return Coordinator.getInstance().getAccessControl().checkCanSelectFromTable4Pipe(userName, new QualifiedObjectName(node.getDatabase(), node.getTableName())) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitDeleteData(RelationalDeleteDataNode node, String userName) {
        List<TableDeletionEntry> modEntries = node.getModEntries().stream().filter(entry -> Coordinator.getInstance().getAccessControl().checkCanSelectFromTable4Pipe(userName, new QualifiedObjectName(node.getDatabaseName(), entry.getTableName()))).collect(Collectors.toList());
        return !modEntries.isEmpty() ? Optional.of(new RelationalDeleteDataNode(node.getPlanNodeId(), modEntries, node.getDatabaseName())) : Optional.empty();
    }
}

