/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

public class MemoryEstimationHelper {
    private static final long PARTIAL_PATH_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PartialPath.class);
    private static final long ALIGNED_PATH_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedPath.class);
    private static final long MEASUREMENT_PATH_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedPath.class);
    private static final long ARRAY_LIST_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    private static final long INTEGER_INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Integer.class);

    private MemoryEstimationHelper() {
    }

    public static long getEstimatedSizeOfAccountableObject(@Nullable Accountable accountable) {
        return accountable == null ? 0L : accountable.ramBytesUsed();
    }

    public static long getEstimatedSizeOfPartialPath(@Nullable PartialPath partialPath) {
        if (partialPath == null) {
            return 0L;
        }
        long totalSize = 0L;
        String[] nodes = partialPath.getNodes();
        if (nodes != null && nodes.length > 0) {
            totalSize += Arrays.stream(nodes).mapToLong(RamUsageEstimator::sizeOf).sum();
        }
        if (partialPath instanceof AlignedPath) {
            totalSize += partialPath.getIDeviceID().ramBytesUsed();
            totalSize += RamUsageEstimator.sizeOf((String)partialPath.getFullPath());
            totalSize += ALIGNED_PATH_INSTANCE_SIZE;
            AlignedPath alignedPath = (AlignedPath)partialPath;
            totalSize += alignedPath.getMeasurementList().stream().mapToLong(RamUsageEstimator::sizeOf).sum();
            totalSize += alignedPath.getSchemaList().stream().mapToLong(schema -> RamUsageEstimator.sizeOf((String)schema.getMeasurementName())).sum();
        } else if (partialPath instanceof MeasurementPath) {
            totalSize += partialPath.getIDeviceID().ramBytesUsed();
            totalSize += RamUsageEstimator.sizeOf((String)partialPath.getFullPath());
            totalSize += MEASUREMENT_PATH_INSTANCE_SIZE;
            MeasurementPath measurementPath = (MeasurementPath)partialPath;
            totalSize += RamUsageEstimator.sizeOf((String)measurementPath.getMeasurementAlias());
            if (measurementPath.getMeasurementSchema() != null) {
                totalSize += RamUsageEstimator.sizeOf((String)measurementPath.getMeasurementSchema().getMeasurementName());
            }
        } else {
            totalSize += PARTIAL_PATH_INSTANCE_SIZE;
            totalSize += partialPath.getIDeviceID().ramBytesUsed();
            totalSize += RamUsageEstimator.sizeOf((String)partialPath.getFullPath());
        }
        return totalSize;
    }

    public static long getEstimatedSizeOfCopiedPartialPath(@Nullable PartialPath partialPath) {
        if (partialPath == null) {
            return 0L;
        }
        return PARTIAL_PATH_INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf((Object[])partialPath.getNodes());
    }

    public static long getEstimatedSizeOfIntegerArrayList(List<Integer> integerArrayList) {
        if (integerArrayList == null) {
            return 0L;
        }
        long size = ARRAY_LIST_INSTANCE_SIZE;
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)integerArrayList.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        return RamUsageEstimator.alignObjectSize((long)(size += INTEGER_INSTANCE_SIZE * (long)integerArrayList.size()));
    }
}

