/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class LimitOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LimitOperator.class);
    private final OperatorContext operatorContext;
    private long remainingLimit;
    private final Operator child;

    public LimitOperator(OperatorContext operatorContext, long limit, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        this.remainingLimit = limit;
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    public LimitOperator(LimitOperator limitOperator, Operator child) {
        this.operatorContext = limitOperator.operatorContext;
        this.remainingLimit = limitOperator.remainingLimit;
        this.child = child;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock block = this.child.nextWithTimer();
        if (block == null) {
            return null;
        }
        TsBlock res = block;
        if ((long)block.getPositionCount() <= this.remainingLimit) {
            this.remainingLimit -= (long)block.getPositionCount();
        } else {
            res = block.getRegion(0, (int)this.remainingLimit);
            this.remainingLimit = 0L;
        }
        return res;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.remainingLimit > 0L && this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.remainingLimit == 0L || this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemoryWithCounter();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

