/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher;

import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.ArrayView;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.IntMultimap;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.tsfile.utils.RamUsageEstimator;

class PatternCaptures {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Captures.class);
    private final IntMultimap captures;
    private final IntMultimap labels;

    public PatternCaptures(int initialCapacity, int slotCount, int labelCount) {
        this.captures = new IntMultimap(initialCapacity, slotCount);
        this.labels = new IntMultimap(initialCapacity, labelCount);
    }

    public void save(int threadId, int value) {
        this.captures.add(threadId, value);
    }

    public void saveLabel(int threadId, int value) {
        this.labels.add(threadId, value);
    }

    public void copy(int parent, int child) {
        this.captures.copy(parent, child);
        this.labels.copy(parent, child);
    }

    public ArrayView getCaptures(int threadId) {
        return this.captures.getArrayView(threadId);
    }

    public ArrayView getLabels(int threadId) {
        return this.labels.getArrayView(threadId);
    }

    public void release(int threadId) {
        this.captures.release(threadId);
        this.labels.release(threadId);
    }

    public long getSizeInBytes() {
        return INSTANCE_SIZE + this.captures.getSizeInBytes() + this.labels.getSizeInBytes();
    }
}

