/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BinaryBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BooleanBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.FloatBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class GroupedLastAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedLastAccumulator.class);
    private final TSDataType seriesDataType;
    private final LongBigArray maxTimes = new LongBigArray(Long.MIN_VALUE);
    private LongBigArray longValues;
    private IntBigArray intValues;
    private FloatBigArray floatValues;
    private DoubleBigArray doubleValues;
    private BinaryBigArray binaryValues;
    private BooleanBigArray booleanValues;

    public GroupedLastAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        switch (seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues = new IntBigArray();
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues = new LongBigArray();
                return;
            }
            case FLOAT: {
                this.floatValues = new FloatBigArray();
                return;
            }
            case DOUBLE: {
                this.doubleValues = new DoubleBigArray();
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryValues = new BinaryBigArray();
                return;
            }
            case BOOLEAN: {
                this.booleanValues = new BooleanBigArray();
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", seriesDataType));
    }

    @Override
    public long getEstimatedSize() {
        long valuesSize = 0L;
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                valuesSize += this.intValues.sizeOf();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valuesSize += this.longValues.sizeOf();
                break;
            }
            case FLOAT: {
                valuesSize += this.floatValues.sizeOf();
                break;
            }
            case DOUBLE: {
                valuesSize += this.doubleValues.sizeOf();
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                valuesSize += this.binaryValues.sizeOf();
                break;
            }
            case BOOLEAN: {
                valuesSize += this.booleanValues.sizeOf();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
            }
        }
        return INSTANCE_SIZE + valuesSize;
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.maxTimes.ensureCapacity(groupCount);
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues.ensureCapacity(groupCount);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues.ensureCapacity(groupCount);
                return;
            }
            case FLOAT: {
                this.floatValues.ensureCapacity(groupCount);
                return;
            }
            case DOUBLE: {
                this.doubleValues.ensureCapacity(groupCount);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryValues.ensureCapacity(groupCount);
                return;
            }
            case BOOLEAN: {
                this.booleanValues.ensureCapacity(groupCount);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments, AggregationMask mask) {
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(groupIds, arguments[0], arguments[1], mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(groupIds, arguments[0], arguments[1], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments[0], arguments[1], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments[0], arguments[1], mask);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(groupIds, arguments[0], arguments[1], mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(groupIds, arguments[0], arguments[1], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of LAST should be BinaryColumn");
        block8: for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long time = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
            int offset = 8;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    int intVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    this.updateIntValue(groupIds[i], intVal, time);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long longVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    this.updateLongValue(groupIds[i], longVal, time);
                    continue block8;
                }
                case FLOAT: {
                    float floatVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    this.updateFloatValue(groupIds[i], floatVal, time);
                    continue block8;
                }
                case DOUBLE: {
                    double doubleVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    this.updateDoubleValue(groupIds[i], doubleVal, time);
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    this.updateBinaryValue(groupIds[i], binaryVal, time);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean boolVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    this.updateBooleanValue(groupIds[i], boolVal, time);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of LAST should be BinaryColumn");
        if (this.maxTimes.get(groupId) == Long.MIN_VALUE) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(this.serializeTimeWithValue(groupId)));
        }
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        if (this.maxTimes.get(groupId) == Long.MIN_VALUE) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(this.intValues.get(groupId));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(this.longValues.get(groupId));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.floatValues.get(groupId));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.doubleValues.get(groupId));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    columnBuilder.writeBinary(this.binaryValues.get(groupId));
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(this.booleanValues.get(groupId));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.maxTimes.reset();
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues.reset();
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues.reset();
                return;
            }
            case FLOAT: {
                this.floatValues.reset();
                return;
            }
            case DOUBLE: {
                this.doubleValues.reset();
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryValues.reset();
                return;
            }
            case BOOLEAN: {
                this.booleanValues.reset();
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
    }

    private byte[] serializeTimeWithValue(int groupId) {
        int length = 8;
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                byte[] bytes = new byte[length += 4];
                BytesUtils.longToBytes((long)this.maxTimes.get(groupId), (byte[])bytes, (int)0);
                BytesUtils.intToBytes((int)this.intValues.get(groupId), (byte[])bytes, (int)8);
                return bytes;
            }
            case INT64: 
            case TIMESTAMP: {
                byte[] bytes = new byte[length += 8];
                BytesUtils.longToBytes((long)this.maxTimes.get(groupId), (byte[])bytes, (int)0);
                BytesUtils.longToBytes((long)this.longValues.get(groupId), (byte[])bytes, (int)8);
                return bytes;
            }
            case FLOAT: {
                byte[] bytes = new byte[length += 4];
                BytesUtils.longToBytes((long)this.maxTimes.get(groupId), (byte[])bytes, (int)0);
                BytesUtils.floatToBytes((float)this.floatValues.get(groupId), (byte[])bytes, (int)8);
                return bytes;
            }
            case DOUBLE: {
                byte[] bytes = new byte[length += 8];
                BytesUtils.longToBytes((long)this.maxTimes.get(groupId), (byte[])bytes, (int)0);
                BytesUtils.doubleToBytes((double)this.doubleValues.get(groupId), (byte[])bytes, (int)8);
                return bytes;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                byte[] values = this.binaryValues.get(groupId).getValues();
                byte[] bytes = new byte[length += 4 + values.length];
                BytesUtils.longToBytes((long)this.maxTimes.get(groupId), (byte[])bytes, (int)0);
                BytesUtils.intToBytes((int)values.length, (byte[])bytes, (int)8);
                System.arraycopy(values, 0, bytes, length - values.length, values.length);
                return bytes;
            }
            case BOOLEAN: {
                byte[] bytes = new byte[++length];
                BytesUtils.longToBytes((long)this.maxTimes.get(groupId), (byte[])bytes, (int)0);
                BytesUtils.boolToBytes((boolean)this.booleanValues.get(groupId), (byte[])bytes, (int)8);
                return bytes;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LAST Aggregation: %s", this.seriesDataType));
    }

    private void addIntInput(int[] groupIds, Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateIntValue(groupIds[i], valueColumn.getInt(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateIntValue(groupIds[position], valueColumn.getInt(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateIntValue(int groupId, int value, long curTime) {
        long maxTime = this.maxTimes.get(groupId);
        if (curTime > maxTime) {
            this.maxTimes.set(groupId, curTime);
            this.intValues.set(groupId, value);
        }
    }

    private void addLongInput(int[] groupIds, Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateLongValue(groupIds[i], valueColumn.getLong(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateLongValue(groupIds[position], valueColumn.getLong(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateLongValue(int groupId, long value, long curTime) {
        long maxTime = this.maxTimes.get(groupId);
        if (curTime > maxTime) {
            this.maxTimes.set(groupId, curTime);
            this.longValues.set(groupId, value);
        }
    }

    private void addFloatInput(int[] groupIds, Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateFloatValue(groupIds[i], valueColumn.getFloat(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateFloatValue(groupIds[position], valueColumn.getFloat(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateFloatValue(int groupId, float value, long curTime) {
        long maxTime = this.maxTimes.get(groupId);
        if (curTime > maxTime) {
            this.maxTimes.set(groupId, curTime);
            this.floatValues.set(groupId, value);
        }
    }

    private void addDoubleInput(int[] groupIds, Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateDoubleValue(groupIds[i], valueColumn.getDouble(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateDoubleValue(groupIds[position], valueColumn.getDouble(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateDoubleValue(int groupId, double value, long curTime) {
        long maxTime = this.maxTimes.get(groupId);
        if (curTime > maxTime) {
            this.maxTimes.set(groupId, curTime);
            this.doubleValues.set(groupId, value);
        }
    }

    private void addBinaryInput(int[] groupIds, Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBinaryValue(groupIds[i], valueColumn.getBinary(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBinaryValue(groupIds[position], valueColumn.getBinary(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateBinaryValue(int groupId, Binary value, long curTime) {
        long maxTime = this.maxTimes.get(groupId);
        if (curTime > maxTime) {
            this.maxTimes.set(groupId, curTime);
            this.binaryValues.set(groupId, value);
        }
    }

    private void addBooleanInput(int[] groupIds, Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBooleanValue(groupIds[i], valueColumn.getBoolean(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBooleanValue(groupIds[position], valueColumn.getBoolean(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateBooleanValue(int groupId, boolean value, long curTime) {
        long maxTime = this.maxTimes.get(groupId);
        if (curTime > maxTime) {
            this.maxTimes.set(groupId, curTime);
            this.booleanValues.set(groupId, value);
        }
    }
}

