/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryPlanCostMetricSet
implements IMetricSet {
    private static final QueryPlanCostMetricSet INSTANCE = new QueryPlanCostMetricSet();
    public static final String TABLE_TYPE = "table";
    public static final String TREE_TYPE = "tree";
    public static final String ANALYZER = "analyzer";
    public static final String LOGICAL_PLANNER = "logical_planner";
    public static final String LOGICAL_PLAN_OPTIMIZE = "logical_plan_optimize";
    public static final String DISTRIBUTION_PLANNER = "distribution_planner";
    public static final String PARTITION_FETCHER = "partition_fetcher";
    public static final String SCHEMA_FETCHER = "schema_fetcher";
    private Timer treeAnalyzerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer treeLogicalPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer treeLogicalPlanOptimizerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer treeDistributionPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer treePartitionFetcherTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer treeSchemaFetcherTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tableAnalyzerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tableLogicalPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tableLogicalPlanOptimizerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tableDistributionPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tablePartitionFetcherTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tableSchemaFetcherTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private QueryPlanCostMetricSet() {
    }

    public void recordTreePlanCost(String stage, long costTimeInNanos) {
        switch (stage) {
            case "analyzer": {
                this.treeAnalyzerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "logical_planner": {
                this.treeLogicalPlannerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "logical_plan_optimize": {
                this.treeLogicalPlanOptimizerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "distribution_planner": {
                this.treeDistributionPlannerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "partition_fetcher": {
                this.treePartitionFetcherTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "schema_fetcher": {
                this.treeSchemaFetcherTimer.updateNanos(costTimeInNanos);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported stage in tree model: " + stage);
            }
        }
    }

    public void recordTablePlanCost(String stage, long costTimeInNanos) {
        switch (stage) {
            case "analyzer": {
                this.tableAnalyzerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "logical_planner": {
                this.tableLogicalPlannerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "logical_plan_optimize": {
                this.tableLogicalPlanOptimizerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "distribution_planner": {
                this.tableDistributionPlannerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "partition_fetcher": {
                this.tablePartitionFetcherTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "schema_fetcher": {
                this.tableSchemaFetcherTimer.updateNanos(costTimeInNanos);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported stage in table model: " + stage);
            }
        }
    }

    public void bindTo(AbstractMetricService metricService) {
        this.treeAnalyzerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TREE_TYPE, Tag.STAGE.toString(), ANALYZER});
        this.treeLogicalPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TREE_TYPE, Tag.STAGE.toString(), LOGICAL_PLANNER});
        this.treeLogicalPlanOptimizerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TREE_TYPE, Tag.STAGE.toString(), LOGICAL_PLAN_OPTIMIZE});
        this.treeDistributionPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TREE_TYPE, Tag.STAGE.toString(), DISTRIBUTION_PLANNER});
        this.treePartitionFetcherTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TREE_TYPE, Tag.STAGE.toString(), PARTITION_FETCHER});
        this.treeSchemaFetcherTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TREE_TYPE, Tag.STAGE.toString(), SCHEMA_FETCHER});
        this.tableAnalyzerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TABLE_TYPE, Tag.STAGE.toString(), ANALYZER});
        this.tableLogicalPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TABLE_TYPE, Tag.STAGE.toString(), LOGICAL_PLANNER});
        this.tableLogicalPlanOptimizerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TABLE_TYPE, Tag.STAGE.toString(), LOGICAL_PLAN_OPTIMIZE});
        this.tableDistributionPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TABLE_TYPE, Tag.STAGE.toString(), DISTRIBUTION_PLANNER});
        this.tablePartitionFetcherTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TABLE_TYPE, Tag.STAGE.toString(), PARTITION_FETCHER});
        this.tableSchemaFetcherTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TABLE_TYPE, Tag.STAGE.toString(), SCHEMA_FETCHER});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Arrays.asList(ANALYZER, LOGICAL_PLANNER, LOGICAL_PLAN_OPTIMIZE, DISTRIBUTION_PLANNER, PARTITION_FETCHER, SCHEMA_FETCHER).forEach(stage -> Arrays.asList(TREE_TYPE, TABLE_TYPE).forEach(type -> metricService.remove(MetricType.TIMER, Metric.QUERY_PLAN_COST.toString(), new String[]{Tag.TYPE.toString(), type, Tag.STAGE.toString(), stage})));
    }

    public static QueryPlanCostMetricSet getInstance() {
        return INSTANCE;
    }
}

