/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.TriggerType;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BytesUtils;

public class ShowTriggersTask
implements IConfigTask {
    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showTriggers();
    }

    public static void buildTsBlock(List<ByteBuffer> allTriggerInformation, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showTriggersColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (allTriggerInformation != null && !allTriggerInformation.isEmpty()) {
            for (ByteBuffer triggerInformationByteBuffer : allTriggerInformation) {
                TriggerInformation triggerInformation = TriggerInformation.deserialize((ByteBuffer)triggerInformationByteBuffer);
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)triggerInformation.getTriggerName()));
                builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)triggerInformation.getEvent().toString()));
                builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)(triggerInformation.isStateful() ? TriggerType.STATEFUL.toString() : TriggerType.STATELESS.toString())));
                builder.getColumnBuilder(3).writeBinary(BytesUtils.valueOf((String)triggerInformation.getTriggerState().toString()));
                builder.getColumnBuilder(4).writeBinary(BytesUtils.valueOf((String)triggerInformation.getPathPattern().toString()));
                builder.getColumnBuilder(5).writeBinary(BytesUtils.valueOf((String)triggerInformation.getClassName()));
                builder.getColumnBuilder(6).writeBinary(BytesUtils.valueOf((String)(!triggerInformation.isStateful() ? "ALL" : String.valueOf(triggerInformation.getDataNodeLocation().getDataNodeId()))));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowTriggersHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

