/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.tsfile.file.metadata.IDeviceID;

public class RelationalInsertRowsNode
extends InsertRowsNode {
    private IDeviceID[] deviceIDs;

    public RelationalInsertRowsNode(PlanNodeId id) {
        super(id);
    }

    public RelationalInsertRowsNode(PlanNodeId id, List<Integer> insertRowNodeIndexList, List<InsertRowNode> insertRowNodeList) {
        super(id);
        this.setInsertRowNodeIndexList(insertRowNodeIndexList);
        this.setInsertRowNodeList(insertRowNodeList);
    }

    public IDeviceID getDeviceID(int rowIdx) {
        if (this.deviceIDs == null) {
            this.deviceIDs = new IDeviceID[this.getInsertRowNodeList().size()];
        }
        if (this.deviceIDs[rowIdx] == null) {
            String[] deviceIdSegments = new String[this.idColumnIndices.size() + 1];
            deviceIdSegments[0] = this.getTableName();
            for (int i = 0; i < this.idColumnIndices.size(); ++i) {
                Integer columnIndex = (Integer)this.idColumnIndices.get(i);
                deviceIdSegments[i + 1] = ((Object[])this.getInsertRowNodeList().get(i).getValues()[columnIndex])[rowIdx].toString();
            }
            this.deviceIDs[rowIdx] = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdSegments);
        }
        return this.deviceIDs[rowIdx];
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRelationalInsertRows(this, context);
    }

    public static RelationalInsertRowsNode deserialize(ByteBuffer byteBuffer) {
        int i;
        ArrayList<InsertRowNode> insertRowNodeList = new ArrayList<InsertRowNode>();
        ArrayList<Integer> insertRowNodeIndex = new ArrayList<Integer>();
        int size = byteBuffer.getInt();
        for (i = 0; i < size; ++i) {
            InsertRowNode insertRowNode = new RelationalInsertRowNode(new PlanNodeId(""));
            ((RelationalInsertRowNode)insertRowNode).subDeserialize(byteBuffer);
            insertRowNodeList.add(insertRowNode);
        }
        for (i = 0; i < size; ++i) {
            insertRowNodeIndex.add(byteBuffer.getInt());
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        for (InsertRowNode insertRowNode : insertRowNodeList) {
            insertRowNode.setPlanNodeId(planNodeId);
        }
        RelationalInsertRowsNode insertRowsNode = new RelationalInsertRowsNode(planNodeId);
        insertRowsNode.setInsertRowNodeList(insertRowNodeList);
        insertRowsNode.setInsertRowNodeIndexList(insertRowNodeIndex);
        return insertRowsNode;
    }

    public static RelationalInsertRowsNode deserializeFromWAL(DataInputStream stream) throws IOException {
        RelationalInsertRowsNode insertRowsNode = new RelationalInsertRowsNode(new PlanNodeId(""));
        long searchIndex = stream.readLong();
        int listSize = stream.readInt();
        for (int i = 0; i < listSize; ++i) {
            RelationalInsertRowNode insertRowNode = RelationalInsertRowNode.subDeserializeFromWAL(stream);
            insertRowsNode.addOneInsertRowNode(insertRowNode, i);
        }
        insertRowsNode.setSearchIndex(searchIndex);
        return insertRowsNode;
    }

    public static RelationalInsertRowsNode deserializeFromWAL(ByteBuffer buffer) {
        RelationalInsertRowsNode insertRowsNode = new RelationalInsertRowsNode(new PlanNodeId(""));
        long searchIndex = buffer.getLong();
        int listSize = buffer.getInt();
        for (int i = 0; i < listSize; ++i) {
            RelationalInsertRowNode insertRowNode = RelationalInsertRowNode.subDeserializeFromWAL(buffer);
            insertRowsNode.addOneInsertRowNode(insertRowNode, i);
        }
        insertRowsNode.setSearchIndex(searchIndex);
        return insertRowsNode;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.RELATIONAL_INSERT_ROWS;
    }

    @Override
    public String getTableName() {
        if (this.targetPath != null) {
            return this.targetPath.getFullPath();
        }
        return this.getInsertRowNodeList().get(0).getTableName();
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        HashMap<TRegionReplicaSet, RelationalInsertRowsNode> splitMap = new HashMap<TRegionReplicaSet, RelationalInsertRowsNode>();
        ArrayList<TEndPoint> redirectInfo = new ArrayList<TEndPoint>();
        for (int i = 0; i < this.getInsertRowNodeList().size(); ++i) {
            InsertRowNode insertRowNode = this.getInsertRowNodeList().get(i);
            TRegionReplicaSet dataRegionReplicaSet = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(insertRowNode.getDeviceID(), TimePartitionUtils.getTimePartitionSlot((long)insertRowNode.getTime()), analysis.getDatabaseName());
            redirectInfo.add(((TDataNodeLocation)dataRegionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint());
            RelationalInsertRowsNode tmpNode = (RelationalInsertRowsNode)splitMap.get(dataRegionReplicaSet);
            if (tmpNode != null) {
                tmpNode.addOneInsertRowNode(insertRowNode, i);
                continue;
            }
            tmpNode = new RelationalInsertRowsNode(this.getPlanNodeId());
            tmpNode.setDataRegionReplicaSet(dataRegionReplicaSet);
            tmpNode.addOneInsertRowNode(insertRowNode, i);
            splitMap.put(dataRegionReplicaSet, tmpNode);
        }
        analysis.setRedirectNodeList(redirectInfo);
        return new ArrayList<WritePlanNode>(splitMap.values());
    }

    @Override
    public RelationalInsertRowsNode emptyClone() {
        return new RelationalInsertRowsNode(this.getPlanNodeId());
    }
}

