/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import java.util.Objects;
import java.util.OptionalInt;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;

public class CanonicalizationAware<T extends Node> {
    private final T node;
    private int hashCode;

    private CanonicalizationAware(T node) {
        this.node = (Node)Objects.requireNonNull(node, "node is null");
    }

    public static <T extends Node> CanonicalizationAware<T> canonicalizationAwareKey(T node) {
        return new CanonicalizationAware<T>(node);
    }

    public T getNode() {
        return this.node;
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = AstUtil.treeHash(this.node, CanonicalizationAware::canonicalizationAwareHash);
            if (hash == 0) {
                hash = 1;
            }
            this.hashCode = hash;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalizationAware other = (CanonicalizationAware)o;
        return AstUtil.treeEqual(this.node, other.node, CanonicalizationAware::canonicalizationAwareComparison);
    }

    public String toString() {
        return "CanonicalizationAware(" + this.node + ")";
    }

    public static Boolean canonicalizationAwareComparison(Node left, Node right) {
        if (left instanceof Identifier && right instanceof Identifier) {
            Identifier leftIdentifier = (Identifier)left;
            Identifier rightIdentifier = (Identifier)right;
            return leftIdentifier.getCanonicalValue().equals(rightIdentifier.getCanonicalValue());
        }
        return null;
    }

    public static OptionalInt canonicalizationAwareHash(Node node) {
        if (node instanceof Identifier) {
            Identifier identifier = (Identifier)node;
            return OptionalInt.of(identifier.getCanonicalValue().hashCode());
        }
        if (node.getChildren().isEmpty()) {
            return OptionalInt.of(node.hashCode());
        }
        return OptionalInt.empty();
    }
}

