/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate;

import java.util.List;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public class PredicatePushIntoScanChecker
extends PredicateVisitor<Boolean, Void> {
    @Override
    public Boolean visitExpression(Expression expression, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitInPredicate(InPredicate node, Void context) {
        return PredicatePushIntoScanChecker.isSymbolReference(node.getValue());
    }

    @Override
    protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
        throw new IllegalArgumentException("IS NULL Expression can't be pushed down");
    }

    @Override
    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
        return PredicatePushIntoScanChecker.isSymbolReference(node.getValue());
    }

    @Override
    protected Boolean visitLikePredicate(LikePredicate node, Void context) {
        return PredicatePushIntoScanChecker.isSymbolReference(node.getValue()) && PredicatePushIntoScanChecker.isLiteral(node.getPattern()) && node.getEscape().map(PredicatePushIntoScanChecker::isLiteral).orElse(true) != false;
    }

    @Override
    protected Boolean visitLogicalExpression(LogicalExpression node, Void context) {
        List<Expression> children = node.getTerms();
        for (Expression child : children) {
            if (((Boolean)this.process(child, context)).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean visitNotExpression(NotExpression node, Void context) {
        throw new IllegalArgumentException("Not Expression can't be pushed down");
    }

    @Override
    protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
        return PredicatePushIntoScanChecker.isSymbolReference(node.getLeft()) && PredicatePushIntoScanChecker.isLiteral(node.getRight()) || PredicatePushIntoScanChecker.isSymbolReference(node.getRight()) && PredicatePushIntoScanChecker.isLiteral(node.getLeft());
    }

    @Override
    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitIfExpression(IfExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
        return PredicatePushIntoScanChecker.isSymbolReference(node.getValue()) && PredicatePushIntoScanChecker.isLiteral(node.getMin()) && PredicatePushIntoScanChecker.isLiteral(node.getMax()) || PredicatePushIntoScanChecker.isLiteral(node.getValue()) && PredicatePushIntoScanChecker.isSymbolReference(node.getMin()) && PredicatePushIntoScanChecker.isLiteral(node.getMax()) || PredicatePushIntoScanChecker.isLiteral(node.getValue()) && PredicatePushIntoScanChecker.isLiteral(node.getMin()) && PredicatePushIntoScanChecker.isSymbolReference(node.getMax());
    }

    public static boolean isLiteral(Expression expression) {
        return expression instanceof Literal;
    }

    public static boolean isSymbolReference(Expression expression) {
        return expression instanceof SymbolReference;
    }
}

