/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;

public class CastToDoubleLiteralVisitor
extends AstVisitor<Double, Void> {
    @Override
    protected Double visitLiteral(Literal node, Void context) {
        throw new UnsupportedOperationException("Unhandled literal type: " + node);
    }

    @Override
    protected Double visitBooleanLiteral(BooleanLiteral node, Void context) {
        return node.getValue() ? 1.0 : 0.0;
    }

    @Override
    protected Double visitLongLiteral(LongLiteral node, Void context) {
        return node.getParsedValue();
    }

    @Override
    protected Double visitDoubleLiteral(DoubleLiteral node, Void context) {
        return node.getValue();
    }

    @Override
    protected Double visitStringLiteral(StringLiteral node, Void context) {
        try {
            return Double.parseDouble(node.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Double visitBinaryLiteral(BinaryLiteral node, Void context) {
        return null;
    }

    @Override
    protected Double visitGenericLiteral(GenericLiteral node, Void context) {
        try {
            return Double.parseDouble(node.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Double visitNullLiteral(NullLiteral node, Void context) {
        return null;
    }
}

