/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ExpressionSymbolInliner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class InlineProjections
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final PlannerContext plannerContext;

    public InlineProjections(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = captures.get(CHILD);
        return InlineProjections.inlineProjections(this.plannerContext, parent, child, context.getSessionInfo(), context.getSymbolAllocator().getTypes()).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    static Optional<ProjectNode> inlineProjections(PlannerContext plannerContext, ProjectNode parent, ProjectNode child, SessionInfo sessionInfo, TypeProvider types) {
        if (parent.isIdentity() && child.isIdentity()) {
            return Optional.of((ProjectNode)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)child.getChild())));
        }
        Set<Symbol> targets = InlineProjections.extractInliningTargets(plannerContext, parent, child, sessionInfo, types);
        if (targets.isEmpty()) {
            return Optional.empty();
        }
        Assignments assignments = child.getAssignments().filter(targets::contains);
        LinkedHashMap<Symbol, Expression> parentAssignments = new LinkedHashMap<Symbol, Expression>(parent.getAssignments().getMap().size());
        for (Map.Entry<Symbol, Expression> entry2 : parent.getAssignments().getMap().entrySet()) {
            parentAssignments.put(entry2.getKey(), InlineProjections.inlineReferences(entry2.getValue(), assignments));
        }
        Set inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(entry -> SymbolsExtractor.extractAll(entry).stream()).collect(Collectors.toSet());
        Assignments.Builder newChildAssignmentsBuilder = Assignments.builder();
        for (Map.Entry<Symbol, Expression> assignment : child.getAssignments().entrySet()) {
            if (targets.contains(assignment.getKey())) continue;
            newChildAssignmentsBuilder.put(assignment);
            if (InlineProjections.isSymbolReference(assignment.getKey(), assignment.getValue())) continue;
            inputs.remove(assignment.getKey());
        }
        for (Symbol input : inputs) {
            newChildAssignmentsBuilder.putIdentity(input);
        }
        Assignments newChildAssignments = newChildAssignmentsBuilder.build();
        PlanNode newChild = newChildAssignments.isIdentity() ? child.getChild() : new ProjectNode(child.getPlanNodeId(), child.getChild(), newChildAssignments);
        return Optional.of(new ProjectNode(parent.getPlanNodeId(), newChild, Assignments.copyOf(parentAssignments)));
    }

    private static Expression inlineReferences(Expression expression, Assignments assignments) {
        Function<Symbol, Expression> mapping = symbol -> {
            Expression result = assignments.get((Symbol)symbol);
            if (result != null) {
                return result;
            }
            return symbol.toSymbolReference();
        };
        return ExpressionSymbolInliner.inlineSymbols(mapping, expression);
    }

    private static Set<Symbol> extractInliningTargets(PlannerContext plannerContext, ProjectNode parent, ProjectNode child, SessionInfo sessionInfo, TypeProvider types) {
        ImmutableSet childOutputSet = ImmutableSet.copyOf(child.getOutputSymbols());
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> SymbolsExtractor.extractAll(expression).stream()).filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set basicReferences = dependencies.keySet().stream().filter(input -> IrUtils.isEffectivelyLiteral(child.getAssignments().get((Symbol)input), plannerContext, sessionInfo) || child.getAssignments().get((Symbol)input) instanceof SymbolReference).filter(input -> !child.getAssignments().isIdentity((Symbol)input)).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !child.getAssignments().isIdentity((Symbol)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, basicReferences);
    }

    private static boolean isSymbolReference(Symbol symbol, Expression expression) {
        return expression instanceof SymbolReference && ((SymbolReference)expression).getName().equals(symbol.getName());
    }
}

