/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ChildReplacer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PruneDistinctAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(PruneDistinctAggregation::isDistinctOperator);

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        Lookup lookup = context.getLookup();
        DistinctAggregationRewriter rewriter = new DistinctAggregationRewriter(lookup);
        List newSources = (List)node.getChildren().stream().map(lookup::resolve).map(source -> source.accept(rewriter, true)).collect(ImmutableList.toImmutableList());
        if (rewriter.isRewritten()) {
            return Rule.Result.ofPlanNode(ChildReplacer.replaceChildren(node, newSources));
        }
        return Rule.Result.empty();
    }

    private static boolean isDistinctOperator(AggregationNode node) {
        return node.getAggregations().isEmpty();
    }

    private static class DistinctAggregationRewriter
    extends PlanVisitor<PlanNode, Boolean> {
        private final Lookup lookup;
        private boolean rewritten;

        public DistinctAggregationRewriter(Lookup lookup) {
            this.lookup = lookup;
            this.rewritten = false;
        }

        public boolean isRewritten() {
            return this.rewritten;
        }

        private PlanNode rewriteChildren(PlanNode node, Boolean context) {
            List newSources = (List)node.getChildren().stream().map(this.lookup::resolve).map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            return ChildReplacer.replaceChildren(node, newSources);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Boolean context) {
            return this.rewriteChildren(node, false);
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, Boolean context) {
            boolean distinct = PruneDistinctAggregation.isDistinctOperator(node);
            PlanNode rewrittenNode = this.lookup.resolve(node.getChild()).accept(this, distinct);
            if (context.booleanValue() && distinct) {
                this.rewritten = true;
                return rewrittenNode;
            }
            return AggregationNode.builderFrom(node).setSource(rewrittenNode).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build();
        }
    }
}

