/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TimeDuration;

public class PreviousFillNode
extends FillNode {
    @Nullable
    private final TimeDuration timeBound;
    @Nullable
    private final Symbol helperColumn;
    @Nullable
    private final List<Symbol> groupingKeys;

    public PreviousFillNode(PlanNodeId id, PlanNode child, TimeDuration timeBound, Symbol helperColumn, List<Symbol> groupingKeys) {
        super(id, child);
        this.timeBound = timeBound;
        this.helperColumn = helperColumn;
        this.groupingKeys = groupingKeys;
    }

    public Optional<TimeDuration> getTimeBound() {
        return Optional.ofNullable(this.timeBound);
    }

    public Optional<Symbol> getHelperColumn() {
        return Optional.ofNullable(this.helperColumn);
    }

    public Optional<List<Symbol>> getGroupingKeys() {
        return Optional.ofNullable(this.groupingKeys);
    }

    @Override
    public PlanNode clone() {
        return new PreviousFillNode(this.id, null, this.timeBound, this.helperColumn, this.groupingKeys);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPreviousFill(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_PREVIOUS_FILL_NODE.serialize(byteBuffer);
        if (this.timeBound == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            this.timeBound.serialize(byteBuffer);
        }
        if (this.helperColumn == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            Symbol.serialize(this.helperColumn, byteBuffer);
        }
        if (this.groupingKeys == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.groupingKeys.size(), (ByteBuffer)byteBuffer);
            for (Symbol symbol : this.groupingKeys) {
                Symbol.serialize(symbol, byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_PREVIOUS_FILL_NODE.serialize(stream);
        if (this.timeBound == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.timeBound.serialize(stream);
        }
        if (this.helperColumn == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            Symbol.serialize(this.helperColumn, stream);
        }
        if (this.groupingKeys == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.groupingKeys.size(), (OutputStream)stream);
            for (Symbol symbol : this.groupingKeys) {
                Symbol.serialize(symbol, stream);
            }
        }
    }

    public static PreviousFillNode deserialize(ByteBuffer byteBuffer) {
        boolean hasValue = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        TimeDuration timeDuration = null;
        if (hasValue) {
            timeDuration = TimeDuration.deserialize((ByteBuffer)byteBuffer);
        }
        hasValue = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        Symbol helperColumn = null;
        if (hasValue) {
            helperColumn = Symbol.deserialize(byteBuffer);
        }
        hasValue = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        ArrayList<Symbol> groupingKeys = null;
        if (hasValue) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            groupingKeys = new ArrayList<Symbol>(size);
            while (size-- > 0) {
                groupingKeys.add(Symbol.deserialize(byteBuffer));
            }
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new PreviousFillNode(planNodeId, null, timeDuration, helperColumn, groupingKeys);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new PreviousFillNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.timeBound, this.helperColumn, this.groupingKeys);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreviousFillNode that = (PreviousFillNode)o;
        return Objects.equals(this.timeBound, that.timeBound) && Objects.equals(this.helperColumn, that.helperColumn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeBound, this.helperColumn);
    }

    public String toString() {
        return "PreviousFillNode-" + this.getPlanNodeId();
    }
}

