/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.DeviceAttributeCacheUpdater;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableDeviceAttributeCommitUpdateNode
extends PlanNode
implements ISchemaRegionPlan {
    private final long version;
    private final Map<TDataNodeLocation, byte[]> commitMap;
    private final Set<TDataNodeLocation> shrunkNodes;
    private final TDataNodeLocation leaderLocation;
    public static final TableDeviceAttributeCommitUpdateNode MOCK_INSTANCE = new TableDeviceAttributeCommitUpdateNode(new PlanNodeId(""), 0L, null, null, null);

    public TableDeviceAttributeCommitUpdateNode(PlanNodeId id, long version, Map<TDataNodeLocation, byte[]> commitMap, Set<TDataNodeLocation> shrunkNodes, TDataNodeLocation leaderLocation) {
        super(id);
        this.version = version;
        this.commitMap = commitMap;
        this.shrunkNodes = shrunkNodes;
        this.leaderLocation = leaderLocation;
    }

    public long getVersion() {
        return this.version;
    }

    public Map<TDataNodeLocation, byte[]> getCommitMap() {
        return this.commitMap;
    }

    public Set<TDataNodeLocation> getShrunkNodes() {
        return this.shrunkNodes;
    }

    public TDataNodeLocation getLeaderLocation() {
        return this.leaderLocation;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_DEVICE_ATTRIBUTE_COMMIT;
    }

    @Override
    public PlanNode clone() {
        return new TableDeviceAttributeCommitUpdateNode(this.id, this.version, this.commitMap, this.shrunkNodes, this.leaderLocation);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableDeviceAttributeCommit(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        this.getType().serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.version, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.commitMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<TDataNodeLocation, byte[]> entry : this.commitMap.entrySet()) {
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(entry.getKey(), byteBuffer);
            ReadWriteIOUtils.write((int)entry.getValue().length, (ByteBuffer)byteBuffer);
            byteBuffer.put(entry.getValue());
        }
        ReadWriteIOUtils.write((int)this.shrunkNodes.size(), (ByteBuffer)byteBuffer);
        for (TDataNodeLocation location : this.shrunkNodes) {
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(location, byteBuffer);
        }
        DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.leaderLocation, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.getType().serialize(stream);
        ReadWriteIOUtils.write((long)this.version, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.commitMap.size(), (OutputStream)stream);
        for (Map.Entry<TDataNodeLocation, byte[]> entry : this.commitMap.entrySet()) {
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(entry.getKey(), stream);
            ReadWriteIOUtils.write((int)entry.getValue().length, (OutputStream)stream);
            stream.write(entry.getValue());
        }
        ReadWriteIOUtils.write((int)this.shrunkNodes.size(), (OutputStream)stream);
        for (TDataNodeLocation location : this.shrunkNodes) {
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(location, stream);
        }
        DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.leaderLocation, stream);
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        long version = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<TDataNodeLocation, byte[]> commitMap = new HashMap<TDataNodeLocation, byte[]>(size);
        for (int i = 0; i < size; ++i) {
            TDataNodeLocation location = DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(buffer);
            byte[] commitBuffer = new byte[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
            buffer.get(commitBuffer);
            commitMap.put(location, commitBuffer);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashSet<TDataNodeLocation> shrunkNodes = new HashSet<TDataNodeLocation>();
        for (int i = 0; i < size; ++i) {
            shrunkNodes.add(DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(buffer));
        }
        TDataNodeLocation localLocation = DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new TableDeviceAttributeCommitUpdateNode(planNodeId, version, commitMap, shrunkNodes, localLocation);
    }

    @Override
    public SchemaRegionPlanType getPlanType() {
        return SchemaRegionPlanType.COMMIT_UPDATE_TABLE_DEVICE_ATTRIBUTE;
    }

    @Override
    public <R, C> R accept(SchemaRegionPlanVisitor<R, C> visitor, C context) {
        return visitor.visitCommitUpdateTableDeviceAttribute(this, context);
    }
}

