/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;

public class IrExclusion
extends IrRowPattern {
    private final IrRowPattern pattern;

    public IrExclusion(IrRowPattern pattern) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
    }

    public IrRowPattern getPattern() {
        return this.pattern;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrExclusion(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrExclusion o = (IrExclusion)obj;
        return Objects.equals(this.pattern, o.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public String toString() {
        return "{-" + this.pattern + "-}";
    }

    public static void serialize(IrExclusion pattern, ByteBuffer byteBuffer) {
        IrRowPattern.serialize(pattern.pattern, byteBuffer);
    }

    public static void serialize(IrExclusion pattern, DataOutputStream stream) throws IOException {
        IrRowPattern.serialize(pattern.pattern, stream);
    }

    public static IrExclusion deserialize(ByteBuffer byteBuffer) {
        IrRowPattern pattern = IrRowPattern.deserialize(byteBuffer);
        return new IrExclusion(pattern);
    }
}

