/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class CountStatement
extends Statement {
    private final String tableName;
    private final Optional<Expression> where;

    public CountStatement(NodeLocation location, String tableName, Optional<Expression> where) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = tableName;
        this.where = where;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCountStatement(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountStatement that = (CountStatement)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.where, that.where);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("where", this.where.orElse(null)).omitNullValues().toString();
    }
}

