/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class VariableDefinition
extends Node {
    private final Identifier name;
    private final Expression expression;

    public VariableDefinition(NodeLocation location, Identifier name, Expression expression) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitVariableDefinition(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("expression", (Object)this.expression).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDefinition that = (VariableDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.expression);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!VariableDefinition.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.name, ((VariableDefinition)other).name);
    }
}

