/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NumericParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignature;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureParameter;
import org.apache.tsfile.read.common.type.Type;

public class TypeSignatureTranslator {
    private TypeSignatureTranslator() {
    }

    public static DataType toSqlType(Type type) {
        return new GenericDataType(new Identifier(type.getTypeEnum().name(), false), Collections.emptyList());
    }

    public static TypeSignature toTypeSignature(DataType type) {
        return TypeSignatureTranslator.toTypeSignature(type, Collections.emptySet());
    }

    private static TypeSignature toTypeSignature(DataType type, Set<String> typeVariables) {
        if (type instanceof GenericDataType) {
            return TypeSignatureTranslator.toTypeSignature((GenericDataType)type, typeVariables);
        }
        throw new UnsupportedOperationException("Unsupported DataType: " + type.getClass().getName());
    }

    private static TypeSignature toTypeSignature(GenericDataType type, Set<String> typeVariables) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        Preconditions.checkArgument((!typeVariables.contains(type.getName().getValue()) ? 1 : 0) != 0, (Object)"Base type name cannot be a type variable");
        for (DataTypeParameter parameter : type.getArguments()) {
            Object value;
            if (parameter instanceof NumericParameter) {
                value = ((NumericParameter)parameter).getValue();
                try {
                    parameters.add((Object)TypeSignatureParameter.numericParameter(Long.parseLong((String)value)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SemanticException(String.format("Invalid type parameter: %s", value));
                }
            }
            if (parameter instanceof TypeParameter) {
                value = ((TypeParameter)parameter).getValue();
                if (value instanceof GenericDataType && ((GenericDataType)value).getArguments().isEmpty() && typeVariables.contains(((GenericDataType)value).getName().getValue())) {
                    parameters.add((Object)TypeSignatureParameter.typeVariable(((GenericDataType)value).getName().getValue()));
                    continue;
                }
                parameters.add((Object)TypeSignatureParameter.typeParameter(TypeSignatureTranslator.toTypeSignature((DataType)value, typeVariables)));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type parameter kind: " + parameter.getClass().getName());
        }
        return new TypeSignature(TypeSignatureTranslator.canonicalize(type.getName()), (List<TypeSignatureParameter>)parameters.build());
    }

    private static String canonicalize(Identifier identifier) {
        if (identifier.isDelimited()) {
            return identifier.getValue();
        }
        return identifier.getValue().toLowerCase(Locale.ENGLISH);
    }
}

