/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.AbstractGreatestLeastColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class BooleanGreatestColumnTransformer
extends AbstractGreatestLeastColumnTransformer {
    protected BooleanGreatestColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    protected void transform(ColumnBuilder builder, List<Column> childrenColumns, int index) {
        boolean allNull = true;
        for (Column column : childrenColumns) {
            if (column.isNull(index)) continue;
            allNull = false;
            if (!column.getBoolean(index)) continue;
            this.returnType.writeBoolean(builder, true);
            return;
        }
        if (allNull) {
            builder.appendNull();
        } else {
            this.returnType.writeBoolean(builder, false);
        }
    }
}

