/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public class RoundFunctionColumnTransformer
extends UnaryColumnTransformer {
    protected int places;

    public RoundFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, int places) {
        super(returnType, childColumnTransformer);
        this.places = places;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        TypeEnum sourceType = this.childColumnTransformer.getType().getTypeEnum();
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, sourceType, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        TypeEnum sourceType = this.childColumnTransformer.getType().getTypeEnum();
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, sourceType, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    private void transform(Column column, ColumnBuilder columnBuilder, TypeEnum sourceType, int i) {
        switch (sourceType) {
            case INT32: {
                columnBuilder.writeDouble(Math.rint((double)column.getInt(i) * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places));
                break;
            }
            case INT64: {
                columnBuilder.writeDouble(Math.rint((double)column.getLong(i) * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places));
                break;
            }
            case FLOAT: {
                columnBuilder.writeDouble(Math.rint((double)column.getFloat(i) * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places));
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(Math.rint(column.getDouble(i) * Math.pow(10.0, this.places)) / Math.pow(10.0, this.places));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", this.childColumnTransformer.getType().getTypeEnum()));
            }
        }
    }
}

