/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.input;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.input.TsBlockInputDataSet;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.SafetyLine;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.RowListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.ElasticSerializableRowList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;

public class QueryDataSetInputLayer {
    private TsBlockInputDataSet queryDataSet;
    private TSDataType[] dataTypes;
    private ElasticSerializableRowList rowList;
    private SafetyLine safetyLine;

    public QueryDataSetInputLayer(String queryId, float memoryBudgetInMB, TsBlockInputDataSet queryDataSet) throws QueryProcessException {
        this.construct(queryId, memoryBudgetInMB, queryDataSet);
    }

    private void construct(String queryId, float memoryBudgetInMB, TsBlockInputDataSet queryDataSet) throws QueryProcessException {
        this.queryDataSet = queryDataSet;
        this.dataTypes = queryDataSet.getDataTypes().toArray(new TSDataType[0]);
        this.rowList = new ElasticSerializableRowList(this.dataTypes, queryId, memoryBudgetInMB, 1 + this.dataTypes.length / 2);
        this.safetyLine = new SafetyLine();
    }

    public void updateRowRecordListEvictionUpperBound() {
        this.rowList.setEvictionUpperBound(this.safetyLine.getSafetyLine());
    }

    public BlockColumnReader constructValueReader(int columnIndex) {
        return new BlockColumnReader(columnIndex);
    }

    public BlockColumnReader constructTimeReader() {
        return new BlockColumnReader(this.dataTypes.length);
    }

    private class BlockColumnReader
    implements LayerReader {
        private final SafetyLine.SafetyPile safetyPile;
        private final int columnIndex;
        private Column[] cachedColumns;
        private int cacheConsumed;
        private final RowListForwardIterator iterator;

        BlockColumnReader(int columnIndex) {
            this.safetyPile = QueryDataSetInputLayer.this.safetyLine.addSafetyPile();
            this.cachedColumns = null;
            this.cacheConsumed = 0;
            this.iterator = QueryDataSetInputLayer.this.rowList.constructIterator();
            this.columnIndex = columnIndex;
        }

        @Override
        public final YieldableState yield() throws Exception {
            if (this.cachedColumns != null && this.cacheConsumed < this.cachedColumns[0].getPositionCount()) {
                return YieldableState.YIELDABLE;
            }
            if (this.iterator.hasNext()) {
                this.iterator.next();
                this.cachedColumns = this.iterator.currentBlock();
                return YieldableState.YIELDABLE;
            }
            YieldableState yieldableState = QueryDataSetInputLayer.this.queryDataSet.yield();
            if (YieldableState.YIELDABLE.equals((Object)yieldableState)) {
                Column[] columns = QueryDataSetInputLayer.this.queryDataSet.currentBlock();
                QueryDataSetInputLayer.this.rowList.put(columns);
                this.iterator.next();
                this.cachedColumns = this.iterator.currentBlock();
            }
            return yieldableState;
        }

        @Override
        public void consumedAll() {
            int steps = this.cachedColumns[0].getPositionCount() - this.cacheConsumed;
            this.safetyPile.moveForward(steps);
            this.cacheConsumed = 0;
            this.cachedColumns = null;
        }

        @Override
        public Column[] current() {
            Column[] columnArray;
            Column valueColumn = this.cachedColumns[this.columnIndex];
            Column timeColumn = this.cachedColumns[this.cachedColumns.length - 1];
            if (this.cacheConsumed == 0) {
                Column[] columnArray2 = new Column[2];
                columnArray2[0] = valueColumn;
                columnArray = columnArray2;
                columnArray2[1] = timeColumn;
            } else {
                Column[] columnArray3 = new Column[2];
                columnArray3[0] = valueColumn.subColumn(this.cacheConsumed);
                columnArray = columnArray3;
                columnArray3[1] = timeColumn.subColumn(this.cacheConsumed);
            }
            return columnArray;
        }

        @Override
        public TSDataType[] getDataTypes() {
            if (this.columnIndex == QueryDataSetInputLayer.this.dataTypes.length) {
                return new TSDataType[]{TSDataType.INT64};
            }
            return new TSDataType[]{QueryDataSetInputLayer.this.dataTypes[this.columnIndex]};
        }

        @Override
        public final boolean isConstantPointReader() {
            return false;
        }
    }
}

