/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.AlignedResourceByPathUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MeasurementResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceByPathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceByPathUtils.class);

    public static ResourceByPathUtils getResourceInstance(IFullPath path) {
        if (path instanceof AlignedFullPath) {
            return new AlignedResourceByPathUtils(path);
        }
        if (path instanceof NonAlignedFullPath) {
            return new MeasurementResourceByPathUtils(path);
        }
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public abstract ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> var1, List<IChunkMetadata> var2) throws IOException;

    public abstract ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext var1, IMemTable var2, List<Pair<ModEntry, IMemTable>> var3, long var4, Filter var6) throws QueryProcessException, IOException;

    public abstract List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter var1, TsFileResource var2, QueryContext var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected Map<TVList, Integer> prepareTvListMapForQuery(QueryContext context, IWritableMemChunk memChunk, boolean isWorkMemTable, Filter globalTimeFilter) {
        void var8_11;
        Filter copyTimeFilter = null;
        if (globalTimeFilter != null) {
            copyTimeFilter = globalTimeFilter.copy();
        }
        LinkedHashMap<TVList, Integer> tvListQueryMap = new LinkedHashMap<TVList, Integer>();
        for (TVList tVList : memChunk.getSortedList()) {
            if (copyTimeFilter != null && !copyTimeFilter.satisfyStartEndTime(tVList.getMinTime(), tVList.getMaxTime())) continue;
            tVList.lockQueryList();
            try {
                LOGGER.debug("Flushing/Working MemTable - add current query context to immutable TVList's query list");
                tVList.getQueryContextSet().add(context);
                tvListQueryMap.put(tVList, tVList.rowCount());
            }
            finally {
                tVList.unlockQueryList();
            }
        }
        TVList list = memChunk.getWorkingTVList();
        Object var8_9 = null;
        list.lockQueryList();
        try {
            if (copyTimeFilter != null && !copyTimeFilter.satisfyStartEndTime(list.getMinTime(), list.getMaxTime())) {
                LinkedHashMap<TVList, Integer> linkedHashMap = tvListQueryMap;
                return linkedHashMap;
            }
            if (!isWorkMemTable) {
                LOGGER.debug("Flushing MemTable - add current query context to mutable TVList's query list");
                list.getQueryContextSet().add(context);
                tvListQueryMap.put(list, list.rowCount());
            } else if (list.isSorted() || list.getQueryContextSet().isEmpty()) {
                LOGGER.debug("Working MemTable - add current query context to mutable TVList's query list when it's sorted or no other query on it");
                list.getQueryContextSet().add(context);
                tvListQueryMap.put(list, list.rowCount());
            } else {
                LOGGER.debug("Working MemTable - clone mutable TVList and replace old TVList in working MemTable");
                QueryContext firstQuery = list.getQueryContextSet().iterator().next();
                if (firstQuery instanceof FragmentInstanceContext) {
                    MemoryReservationManager memoryReservationManager = ((FragmentInstanceContext)firstQuery).getMemoryReservationContext();
                    memoryReservationManager.reserveMemoryCumulatively(list.calculateRamSize());
                }
                list.setOwnerQuery(firstQuery);
                TVList tVList = list.clone();
                tVList.getQueryContextSet().add(context);
                tvListQueryMap.put(tVList, tVList.rowCount());
            }
        }
        finally {
            list.unlockQueryList();
        }
        if (var8_11 != null) {
            memChunk.setWorkingTVList((TVList)var8_11);
        }
        return tvListQueryMap;
    }
}

