/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.TimeSeriesMetadataCacheMetrics;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesMetadataCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final IMemoryBlock CACHE_MEMORY_BLOCK;
    private static final boolean CACHE_ENABLE;
    private final Cache<TimeSeriesMetadataCacheKey, TimeseriesMetadata> lruCache;
    private final AtomicLong entryAverageSize = new AtomicLong(0L);
    private final Map<String, WeakReference<String>> devices = Collections.synchronizedMap(new WeakHashMap());
    private static final String SEPARATOR = "$";

    private TimeSeriesMetadataCache() {
        if (CACHE_ENABLE) {
            logger.info("TimeSeriesMetadataCache size = {}", (Object)CACHE_MEMORY_BLOCK.getTotalMemorySizeInBytes());
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(CACHE_MEMORY_BLOCK.getTotalMemorySizeInBytes()).weigher((key, value) -> (int)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes())).recordStats().build();
        MetricService.getInstance().addMetricSet((IMetricSet)new TimeSeriesMetadataCacheMetrics(this));
    }

    public static TimeSeriesMetadataCache getInstance() {
        return TimeSeriesMetadataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeseriesMetadata get(String filePath, TimeSeriesMetadataCacheKey key, Set<String> allSensors, boolean ignoreNotExists, boolean debug, QueryContext queryContext) throws IOException {
        long startTime = System.nanoTime();
        long loadBloomFilterTime = 0L;
        LongConsumer timeSeriesMetadataIoSizeRecorder = queryContext.getQueryStatistics().getLoadTimeSeriesMetadataActualIOSize()::addAndGet;
        LongConsumer bloomFilterIoSizeRecorder = queryContext.getQueryStatistics().getLoadBloomFilterActualIOSize()::addAndGet;
        boolean cacheHit = true;
        try {
            TimeseriesMetadata timeseriesMetadata;
            TimeseriesMetadata timeseriesMetadata2;
            block23: {
                if (!CACHE_ENABLE) {
                    String deviceStringFormat = key.device.toString();
                    cacheHit = false;
                    TsFileSequenceReader reader = FileReaderManager.getInstance().get(filePath, true, bloomFilterIoSizeRecorder);
                    BloomFilter bloomFilter = reader.readBloomFilter(bloomFilterIoSizeRecorder);
                    queryContext.getQueryStatistics().getLoadBloomFilterFromDiskCount().incrementAndGet();
                    if (bloomFilter != null && !bloomFilter.contains(deviceStringFormat + '.' + key.measurement)) {
                        loadBloomFilterTime = System.nanoTime() - startTime;
                        TimeseriesMetadata timeseriesMetadata3 = null;
                        return timeseriesMetadata3;
                    }
                    loadBloomFilterTime = System.nanoTime() - startTime;
                    TimeseriesMetadata timeseriesMetadata4 = reader.readTimeseriesMetadata(key.device, key.measurement, ignoreNotExists, timeSeriesMetadataIoSizeRecorder);
                    TimeseriesMetadata timeseriesMetadata5 = timeseriesMetadata4 == null || timeseriesMetadata4.getStatistics().getCount() == 0 ? null : timeseriesMetadata4;
                    return timeseriesMetadata5;
                }
                timeseriesMetadata2 = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                if (timeseriesMetadata2 != null) break block23;
                if (debug) {
                    DEBUG_LOGGER.info("Cache miss: {}.{} in file: {}", new Object[]{key.device, key.measurement, filePath});
                    DEBUG_LOGGER.info("Device: {}, all sensors: {}", (Object)key.device, allSensors);
                }
                String deviceStringFormat = key.device.toString();
                WeakReference weakReference = this.devices.computeIfAbsent(deviceStringFormat + SEPARATOR + filePath, WeakReference::new);
                synchronized (weakReference) {
                    long loadBloomFilterStartTime;
                    block22: {
                        timeseriesMetadata2 = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                        if (timeseriesMetadata2 != null) break block23;
                        cacheHit = false;
                        loadBloomFilterStartTime = System.nanoTime();
                        BloomFilter bloomFilter = BloomFilterCache.getInstance().get(new BloomFilterCache.BloomFilterCacheKey(filePath, key.tsFileID), debug, bloomFilterIoSizeRecorder, queryContext.getQueryStatistics().getLoadBloomFilterFromCacheCount()::addAndGet, queryContext.getQueryStatistics().getLoadBloomFilterFromDiskCount()::addAndGet);
                        if (bloomFilter == null || bloomFilter.contains(deviceStringFormat + "." + key.measurement)) break block22;
                        if (debug) {
                            DEBUG_LOGGER.info("TimeSeries meta data {} is filter by bloomFilter!", (Object)key);
                        }
                        loadBloomFilterTime = System.nanoTime() - loadBloomFilterStartTime;
                        TimeseriesMetadata timeseriesMetadata6 = null;
                        return timeseriesMetadata6;
                    }
                    loadBloomFilterTime = System.nanoTime() - loadBloomFilterStartTime;
                    TsFileSequenceReader reader = FileReaderManager.getInstance().get(filePath, true, timeSeriesMetadataIoSizeRecorder);
                    List timeSeriesMetadataList = reader.readTimeseriesMetadata(key.device, key.measurement, allSensors, ignoreNotExists, timeSeriesMetadataIoSizeRecorder);
                    for (TimeseriesMetadata metadata : timeSeriesMetadataList) {
                        TimeSeriesMetadataCacheKey k = new TimeSeriesMetadataCacheKey(key.tsFileID, key.device, metadata.getMeasurementId());
                        if (metadata.getStatistics().getCount() != 0) {
                            this.lruCache.put((Object)k, (Object)metadata);
                        }
                        if (!metadata.getMeasurementId().equals(key.measurement)) continue;
                        timeseriesMetadata2 = metadata.getStatistics().getCount() == 0 ? null : metadata;
                    }
                }
            }
            if (timeseriesMetadata2 == null) {
                if (debug) {
                    DEBUG_LOGGER.info("The file doesn't have this time series {}.", (Object)key);
                }
                timeseriesMetadata = null;
                return timeseriesMetadata;
            }
            if (debug) {
                DEBUG_LOGGER.info("Get timeseries: {}.{}  metadata in file: {}  from cache: {}.", new Object[]{key.device, key.measurement, filePath, timeseriesMetadata2});
            }
            timeseriesMetadata = new TimeseriesMetadata(timeseriesMetadata2);
            return timeseriesMetadata;
        }
        finally {
            queryContext.getQueryStatistics().getLoadBloomFilterTime().getAndAdd(loadBloomFilterTime);
            if (cacheHit) {
                queryContext.getQueryStatistics().getLoadTimeSeriesMetadataFromCacheCount().incrementAndGet();
                queryContext.getQueryStatistics().getLoadTimeSeriesMetadataFromCacheTime().getAndAdd(System.nanoTime() - startTime - loadBloomFilterTime);
            } else {
                queryContext.getQueryStatistics().getLoadTimeSeriesMetadataFromDiskCount().incrementAndGet();
                queryContext.getQueryStatistics().getLoadTimeSeriesMetadataFromDiskTime().getAndAdd(System.nanoTime() - startTime - loadBloomFilterTime);
            }
        }
    }

    public double calculateTimeSeriesMetadataHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return CACHE_MEMORY_BLOCK.getTotalMemorySizeInBytes();
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public double calculateBloomFilterHitRatio() {
        return BloomFilterCache.getInstance().calculateBloomFilterHitRatio();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(TimeSeriesMetadataCacheKey key) {
        this.lruCache.invalidate((Object)key);
    }

    @TestOnly
    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    static {
        CACHE_ENABLE = memoryConfig.isMetaDataCacheEnable();
        CACHE_MEMORY_BLOCK = memoryConfig.getTimeSeriesMetaDataCacheMemoryManager().exactAllocate("TimeSeriesMetadataCache", MemoryBlockType.STATIC);
        CACHE_MEMORY_BLOCK.allocate(CACHE_MEMORY_BLOCK.getTotalMemorySizeInBytes());
    }

    private static class TimeSeriesMetadataCacheHolder {
        private static final TimeSeriesMetadataCache INSTANCE = new TimeSeriesMetadataCache();

        private TimeSeriesMetadataCacheHolder() {
        }
    }

    public static class TimeSeriesMetadataCacheKey {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeSeriesMetadataCacheKey.class) + RamUsageEstimator.shallowSizeOfInstance(String.class);
        private final TsFileID tsFileID;
        private final IDeviceID device;
        private final String measurement;

        public TimeSeriesMetadataCacheKey(TsFileID tsFileID, IDeviceID device, String measurement) {
            this.tsFileID = tsFileID;
            this.device = device;
            this.measurement = measurement;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + this.device.ramBytesUsed() + RamUsageEstimator.sizeOfCharArray((int)this.measurement.length());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesMetadataCacheKey that = (TimeSeriesMetadataCacheKey)o;
            return Objects.equals(this.tsFileID, that.tsFileID) && Objects.equals(this.device, that.device) && Objects.equals(this.measurement, that.measurement);
        }

        public int hashCode() {
            return Objects.hash(this.tsFileID, this.device, this.measurement);
        }

        public String toString() {
            return "TimeSeriesMetadataCacheKey{regionId=" + this.tsFileID.regionId + ", timePartitionId=" + this.tsFileID.timePartitionId + ", tsFileVersion=" + this.tsFileID.fileVersion + ", compactionVersion=" + this.tsFileID.compactionVersion + ", device='" + this.device + '\'' + ", measurement='" + this.measurement + '\'' + '}';
        }
    }
}

