/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.IUnseqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.ReadPointPerformerSubTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionTableSchemaCollector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.IDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.ReadPointCrossCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.ReadPointInnerCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.RepairUnsortedFileCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.control.QueryResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPointCompactionPerformer
implements ICrossCompactionPerformer,
IUnseqCompactionPerformer {
    private final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> seqFiles = Collections.emptyList();
    protected List<TsFileResource> unseqFiles = Collections.emptyList();
    private static final int SUB_TASK_NUM = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    private CompactionTaskSummary summary;
    protected List<TsFileResource> targetFiles = Collections.emptyList();

    public ReadPointCompactionPerformer(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, List<TsFileResource> targetFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
        this.targetFiles = targetFiles;
    }

    public ReadPointCompactionPerformer(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
    }

    public ReadPointCompactionPerformer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Exception {
        long queryId = QueryResourceManager.getInstance().assignCompactionQueryId();
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContextForCompaction(queryId);
        QueryDataSource queryDataSource = this.initQueryDataSource();
        QueryResourceManager.getInstance().getQueryFileManager().addUsedFilesForQuery(queryId, queryDataSource);
        this.summary.setTemporalFileNum(this.targetFiles.size());
        try (AbstractCompactionWriter compactionWriter = this.getCompactionWriter(this.seqFiles, this.unseqFiles, this.targetFiles);){
            MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles, this.unseqFiles);
            List<Schema> schemas = CompactionTableSchemaCollector.collectSchema(this.seqFiles, this.unseqFiles, deviceIterator.getReaderMap());
            compactionWriter.setSchemaForAllTargetFile(schemas);
            while (deviceIterator.hasNextDevice()) {
                this.checkThreadInterrupted();
                Pair<IDeviceID, Boolean> deviceInfo = deviceIterator.nextDevice();
                IDeviceID device = (IDeviceID)deviceInfo.left;
                boolean isAligned = (Boolean)deviceInfo.right;
                queryDataSource.fillOrderIndexes(device, true);
                if (isAligned) {
                    this.compactAlignedSeries(device, deviceIterator, compactionWriter, fragmentInstanceContext, queryDataSource);
                } else {
                    this.compactNonAlignedSeries(device, deviceIterator, compactionWriter, fragmentInstanceContext, queryDataSource);
                }
                this.summary.setTemporaryFileSize(compactionWriter.getWriterSize());
            }
            compactionWriter.endFile();
            CompactionUtils.updatePlanIndexes(this.targetFiles, this.seqFiles, this.unseqFiles);
        }
        finally {
            QueryResourceManager.getInstance().endQuery(queryId);
        }
    }

    protected QueryDataSource initQueryDataSource() {
        return new QueryDataSource(this.seqFiles, this.unseqFiles);
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        this.targetFiles = targetFiles;
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        this.summary = summary;
    }

    private void compactAlignedSeries(IDeviceID device, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter compactionWriter, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource) throws IOException, MetadataException {
        Map<String, MeasurementSchema> schemaMap = deviceIterator.getAllSchemasOfCurrentDevice();
        IMeasurementSchema timeSchema = (IMeasurementSchema)schemaMap.remove("");
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>(schemaMap.values());
        if (measurementSchemas.isEmpty()) {
            return;
        }
        List<String> existedMeasurements = measurementSchemas.stream().map(IMeasurementSchema::getMeasurementName).collect(Collectors.toList());
        fragmentInstanceContext.setIgnoreAllNullRows(device.getTableName().startsWith("root."));
        IDataBlockReader dataBlockReader = ReadPointCompactionPerformer.constructReader(device, existedMeasurements, measurementSchemas, new ArrayList<String>(schemaMap.keySet()), fragmentInstanceContext, queryDataSource, true);
        if (dataBlockReader.hasNextBatch()) {
            compactionWriter.startChunkGroup(device, true);
            measurementSchemas.add(0, (MeasurementSchema)timeSchema);
            compactionWriter.startMeasurement("", (IChunkWriter)new AlignedChunkWriterImpl((IMeasurementSchema)measurementSchemas.remove(0), measurementSchemas), 0);
            ReadPointCompactionPerformer.writeWithReader(compactionWriter, dataBlockReader, device, 0, true);
            compactionWriter.endMeasurement(0);
            compactionWriter.endChunkGroup();
            compactionWriter.checkAndMayFlushChunkMetadata();
        }
    }

    private void compactNonAlignedSeries(IDeviceID device, MultiTsFileDeviceIterator deviceIterator, AbstractCompactionWriter compactionWriter, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource) throws IOException, InterruptedException, ExecutionException {
        Map<String, MeasurementSchema> schemaMap = deviceIterator.getAllSchemasOfCurrentDevice();
        ArrayList<String> allMeasurements = new ArrayList<String>(schemaMap.keySet());
        allMeasurements.sort(String::compareTo);
        int subTaskNums = Math.min(allMeasurements.size(), SUB_TASK_NUM);
        if (subTaskNums > 0) {
            List[] measurementListArray = new List[subTaskNums];
            int size = allMeasurements.size();
            for (int i = 0; i < size; ++i) {
                int n = i % subTaskNums;
                if (measurementListArray[n] == null) {
                    measurementListArray[n] = new LinkedList();
                }
                measurementListArray[n].add((String)allMeasurements.get(i));
            }
            compactionWriter.startChunkGroup(device, false);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (int i = 0; i < subTaskNums; ++i) {
                futures.add(CompactionTaskManager.getInstance().submitSubTask(new ReadPointPerformerSubTask(device, measurementListArray[i], fragmentInstanceContext, new QueryDataSource(queryDataSource), compactionWriter, schemaMap, i)));
            }
            for (Future future : futures) {
                future.get();
            }
            compactionWriter.endChunkGroup();
            compactionWriter.checkAndMayFlushChunkMetadata();
        }
    }

    public static IDataBlockReader constructReader(IDeviceID deviceId, List<String> measurementIds, List<IMeasurementSchema> measurementSchemas, List<String> allSensors, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource, boolean isAlign) {
        Object seriesPath = isAlign ? new AlignedFullPath(deviceId, measurementIds, measurementSchemas) : new NonAlignedFullPath(deviceId, measurementSchemas.get(0));
        return new SeriesDataBlockReader((IFullPath)seriesPath, new HashSet<String>(allSensors), fragmentInstanceContext, queryDataSource, true);
    }

    public static void writeWithReader(AbstractCompactionWriter writer, IDataBlockReader reader, IDeviceID device, int subTaskId, boolean isAligned) throws IOException {
        while (reader.hasNextBatch()) {
            TsBlock tsBlock = reader.nextBatch();
            if (isAligned) {
                writer.write(tsBlock, subTaskId);
                continue;
            }
            TsBlock.TsBlockSingleColumnIterator pointReader = tsBlock.getTsBlockSingleColumnIterator();
            while (pointReader.hasNextTimeValuePair()) {
                writer.write(pointReader.nextTimeValuePair(), subTaskId);
            }
        }
    }

    protected AbstractCompactionWriter getCompactionWriter(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) throws IOException {
        if (!seqFileResources.isEmpty() && !unseqFileResources.isEmpty()) {
            return new ReadPointCrossCompactionWriter(targetFileResources, seqFileResources);
        }
        return new ReadPointInnerCompactionWriter(targetFileResources);
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", this.targetFiles.toString()));
        }
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles;
        this.unseqFiles = unseqFiles;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> unseqFiles) {
        this.unseqFiles = unseqFiles;
    }

    @Override
    public Optional<AbstractInnerSpaceEstimator> getInnerSpaceEstimator() {
        return Optional.of(new RepairUnsortedFileCompactionEstimator());
    }
}

