/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class SingleSeriesCompactionExecutor {
    private IDeviceID device;
    private String measurement;
    private LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList;
    private CompactionTsFileWriter fileWriter;
    private TsFileResource targetResource;
    private IMeasurementSchema schema;
    private ChunkWriterImpl chunkWriter;
    private Chunk cachedChunk;
    private ChunkMetadata cachedChunkMetadata;
    private boolean minStartTimestampSet = false;
    private long minStartTimestamp;
    private boolean maxEndTimestampSet = false;
    private long maxEndTimestamp;
    private boolean lastWriteTimestampSet = false;
    private long lastWriteTimestamp;
    private long pointCountInChunkWriter = 0L;
    private final CompactionTaskSummary summary;
    private final long targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    private final long targetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
    private final long chunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
    private final long chunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();

    public SingleSeriesCompactionExecutor(IDeviceID device, IMeasurementSchema measurementSchema, LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter fileWriter, TsFileResource targetResource) {
        this.device = device;
        this.measurement = measurementSchema.getMeasurementName();
        this.readerAndChunkMetadataList = readerAndChunkMetadataList;
        this.fileWriter = fileWriter;
        this.schema = measurementSchema;
        this.chunkWriter = new ChunkWriterImpl(this.schema);
        this.cachedChunk = null;
        this.cachedChunkMetadata = null;
        this.targetResource = targetResource;
        this.summary = new CompactionTaskSummary();
    }

    public SingleSeriesCompactionExecutor(IDeviceID device, String measurement, LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter fileWriter, TsFileResource targetResource, CompactionTaskSummary summary) {
        this.device = device;
        this.measurement = measurement;
        this.readerAndChunkMetadataList = readerAndChunkMetadataList;
        this.fileWriter = fileWriter;
        this.schema = null;
        this.chunkWriter = null;
        this.cachedChunk = null;
        this.cachedChunkMetadata = null;
        this.targetResource = targetResource;
        this.summary = summary;
    }

    public void execute() throws IOException {
        while (!this.readerAndChunkMetadataList.isEmpty()) {
            Pair<TsFileSequenceReader, List<ChunkMetadata>> readerListPair = this.readerAndChunkMetadataList.removeFirst();
            TsFileSequenceReader reader = (TsFileSequenceReader)readerListPair.left;
            List chunkMetadataList = (List)readerListPair.right;
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Chunk currentChunk = reader.readMemChunk(chunkMetadata);
                this.summary.increaseProcessChunkNum(1);
                this.summary.increaseProcessPointNum(chunkMetadata.getNumOfPoints());
                if (this.chunkWriter == null) {
                    this.constructChunkWriterFromReadChunk(currentChunk);
                }
                if (chunkMetadata.getDeleteIntervalList() != null) {
                    this.processModifiedChunk(currentChunk);
                    continue;
                }
                long chunkSize = this.getChunkSize(currentChunk);
                long chunkPointNum = currentChunk.getChunkStatistic().getCount();
                if (chunkSize >= this.targetChunkSize || chunkPointNum >= this.targetChunkPointNum) {
                    this.processLargeChunk(currentChunk, chunkMetadata);
                    continue;
                }
                if (chunkSize < this.chunkSizeLowerBound && chunkPointNum < this.chunkPointNumLowerBound) {
                    this.processSmallChunk(currentChunk);
                    continue;
                }
                this.processMiddleChunk(currentChunk, chunkMetadata);
            }
        }
        if (this.cachedChunk != null) {
            this.flushChunkToFileWriter(this.cachedChunk, this.cachedChunkMetadata);
            this.cachedChunk = null;
            this.cachedChunkMetadata = null;
        } else if (this.pointCountInChunkWriter != 0L) {
            this.flushChunkWriter();
        }
        this.fileWriter.checkMetadataSizeAndMayFlush();
        if (this.minStartTimestampSet) {
            this.targetResource.updateStartTime(this.device, this.minStartTimestamp);
            this.targetResource.updateEndTime(this.device, this.maxEndTimestamp);
        }
    }

    private void constructChunkWriterFromReadChunk(Chunk chunk) {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.schema = new MeasurementSchema(this.measurement, chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
        this.chunkWriter = new ChunkWriterImpl(this.schema);
    }

    private long getChunkSize(Chunk chunk) {
        return (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize();
    }

    private void processModifiedChunk(Chunk chunk) throws IOException {
        if (this.cachedChunk != null) {
            this.writeCachedChunkIntoChunkWriter();
        }
        this.summary.increaseDeserializedChunkNum(1);
        this.writeChunkIntoChunkWriter(chunk);
        this.flushChunkWriterIfLargeEnough();
    }

    private void processLargeChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        if (this.cachedChunk != null && this.canMerge(this.cachedChunk, chunk)) {
            this.summary.increaseMergedChunkNum(1);
            this.mergeWithCachedChunk(chunk, chunkMetadata);
            this.flushCachedChunkIfLargeEnough();
        } else if (this.cachedChunk != null || this.pointCountInChunkWriter != 0L) {
            this.summary.increaseDeserializedChunkNum(1);
            if (this.cachedChunk != null) {
                this.writeCachedChunkIntoChunkWriter();
            }
            this.writeChunkIntoChunkWriter(chunk);
            this.flushChunkWriterIfLargeEnough();
        } else {
            this.summary.increaseDirectlyFlushChunkNum(1);
            this.flushChunkToFileWriter(chunk, chunkMetadata);
        }
    }

    private void processMiddleChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        if (this.cachedChunk != null && this.canMerge(this.cachedChunk, chunk)) {
            this.summary.increaseMergedChunkNum(1);
            this.mergeWithCachedChunk(chunk, chunkMetadata);
            this.flushCachedChunkIfLargeEnough();
        } else if (this.cachedChunk != null || this.pointCountInChunkWriter != 0L) {
            if (this.cachedChunk != null) {
                this.writeCachedChunkIntoChunkWriter();
            }
            this.summary.increaseDeserializedChunkNum(1);
            this.writeChunkIntoChunkWriter(chunk);
            this.flushChunkWriterIfLargeEnough();
        } else {
            this.summary.increaseMergedChunkNum(1);
            this.cachedChunk = chunk;
            this.cachedChunkMetadata = chunkMetadata;
        }
    }

    private void processSmallChunk(Chunk chunk) throws IOException {
        if (this.cachedChunk != null) {
            this.writeCachedChunkIntoChunkWriter();
        }
        this.summary.increaseDeserializedChunkNum(1);
        this.writeChunkIntoChunkWriter(chunk);
        this.flushChunkWriterIfLargeEnough();
    }

    private boolean canMerge(Chunk chunk1, Chunk chunk2) {
        ChunkHeader header1 = chunk1.getHeader();
        ChunkHeader header2 = chunk2.getHeader();
        return header1.getEncodingType() == header2.getEncodingType() && header1.getCompressionType() == header2.getCompressionType();
    }

    private void writeChunkIntoChunkWriter(Chunk chunk) throws IOException {
        ChunkReader chunkReader = new ChunkReader(chunk);
        while (chunkReader.hasNextSatisfiedPage()) {
            BatchData.BatchDataIterator batchIterator = chunkReader.nextPageData().getBatchDataIterator();
            while (batchIterator.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = batchIterator.nextTimeValuePair();
                this.checkAndUpdatePreviousTimestamp(timeValuePair.getTimestamp());
                this.writeTimeAndValueToChunkWriter(timeValuePair);
                if (!this.maxEndTimestampSet || timeValuePair.getTimestamp() > this.maxEndTimestamp) {
                    this.maxEndTimestamp = timeValuePair.getTimestamp();
                    this.maxEndTimestampSet = true;
                }
                if (this.minStartTimestampSet && timeValuePair.getTimestamp() >= this.minStartTimestamp) continue;
                this.minStartTimestamp = timeValuePair.getTimestamp();
                this.minStartTimestampSet = true;
            }
        }
        long count = chunk.getChunkStatistic().getCount();
        this.pointCountInChunkWriter += count;
        this.summary.increaseRewritePointNum(count);
    }

    private void writeCachedChunkIntoChunkWriter() throws IOException {
        if (this.cachedChunk.getData().position() != 0) {
            this.cachedChunk.getData().flip();
        }
        this.writeChunkIntoChunkWriter(this.cachedChunk);
        this.cachedChunk = null;
        this.cachedChunkMetadata = null;
    }

    private void mergeWithCachedChunk(Chunk currentChunk, ChunkMetadata currentChunkMetadata) throws IOException {
        this.cachedChunk.mergeChunkByAppendPage(currentChunk);
        this.cachedChunkMetadata.mergeChunkMetadata(currentChunkMetadata);
    }

    private void writeTimeAndValueToChunkWriter(TimeValuePair timeValuePair) {
        switch (this.chunkWriter.getDataType()) {
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getBinary());
                break;
            }
            case FLOAT: {
                this.chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getFloat());
                break;
            }
            case DOUBLE: {
                this.chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getDouble());
                break;
            }
            case BOOLEAN: {
                this.chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getBoolean());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getLong());
                break;
            }
            case INT32: 
            case DATE: {
                this.chunkWriter.write(timeValuePair.getTimestamp(), timeValuePair.getValue().getInt());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type " + this.chunkWriter.getDataType());
            }
        }
    }

    private void flushChunkToFileWriter(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        this.checkAndUpdatePreviousTimestamp(chunkMetadata.getStartTime());
        if (!this.minStartTimestampSet || chunkMetadata.getStartTime() < this.minStartTimestamp) {
            this.minStartTimestamp = chunkMetadata.getStartTime();
            this.minStartTimestampSet = true;
        }
        if (!this.maxEndTimestampSet || chunkMetadata.getEndTime() > this.maxEndTimestamp) {
            this.maxEndTimestamp = chunkMetadata.getEndTime();
            this.maxEndTimestampSet = true;
        }
        this.fileWriter.writeChunk(chunk, chunkMetadata);
    }

    private void flushChunkWriterIfLargeEnough() throws IOException {
        if (this.pointCountInChunkWriter >= this.targetChunkPointNum || this.chunkWriter.estimateMaxSeriesMemSize() >= this.targetChunkSize) {
            this.fileWriter.writeChunk((IChunkWriter)this.chunkWriter);
            this.pointCountInChunkWriter = 0L;
        }
    }

    private void flushCachedChunkIfLargeEnough() throws IOException {
        if ((long)this.cachedChunk.getChunkStatistic().getCount() >= this.targetChunkPointNum || this.getChunkSize(this.cachedChunk) >= this.targetChunkSize) {
            this.flushChunkToFileWriter(this.cachedChunk, this.cachedChunkMetadata);
            this.cachedChunk = null;
            this.cachedChunkMetadata = null;
        }
    }

    private void flushChunkWriter() throws IOException {
        this.fileWriter.writeChunk((IChunkWriter)this.chunkWriter);
        this.pointCountInChunkWriter = 0L;
    }

    private void checkAndUpdatePreviousTimestamp(long currentWritingTimestamp) {
        if (this.lastWriteTimestampSet && currentWritingTimestamp <= this.lastWriteTimestamp) {
            throw new CompactionLastTimeCheckFailedException(this.device, this.measurement, currentWritingTimestamp, this.lastWriteTimestamp);
        }
        this.lastWriteTimestamp = currentWritingTimestamp;
        this.lastWriteTimestampSet = true;
    }
}

