/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public abstract class AbstractWritableMemChunk
implements IWritableMemChunk {
    protected static long RETRY_INTERVAL_MS = 100L;
    protected static long MAX_WAIT_QUERY_MS = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeReleaseTvList(TVList tvList) {
        long startTimeInMs = System.currentTimeMillis();
        boolean succeed = false;
        while (!succeed) {
            try {
                this.tryReleaseTvList(tvList);
                succeed = true;
            }
            catch (MemoryNotEnoughException ex) {
                long waitQueryInMs = System.currentTimeMillis() - startTimeInMs;
                if (waitQueryInMs > MAX_WAIT_QUERY_MS) {
                    tvList.lockQueryList();
                    try {
                        Iterator<QueryContext> iterator = tvList.getQueryContextSet().iterator();
                        if (iterator.hasNext()) {
                            FragmentInstanceContext firstQuery = (FragmentInstanceContext)iterator.next();
                            firstQuery.failed((Throwable)((Object)new MemoryNotEnoughException("Memory not enough to clone the tvlist during flush phase")));
                        }
                    }
                    finally {
                        tvList.unlockQueryList();
                    }
                }
                try {
                    Thread.sleep(RETRY_INTERVAL_MS);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryReleaseTvList(TVList tvList) {
        tvList.lockQueryList();
        try {
            if (tvList.getQueryContextSet().isEmpty()) {
                tvList.clear();
            } else {
                QueryContext firstQuery = tvList.getQueryContextSet().iterator().next();
                if (firstQuery instanceof FragmentInstanceContext) {
                    MemoryReservationManager memoryReservationManager = ((FragmentInstanceContext)firstQuery).getMemoryReservationContext();
                    memoryReservationManager.reserveMemoryCumulatively(tvList.calculateRamSize());
                }
                tvList.setOwnerQuery(firstQuery);
            }
        }
        finally {
            tvList.unlockQueryList();
        }
    }

    @Override
    public abstract void putLong(long var1, long var3);

    @Override
    public abstract void putInt(long var1, int var3);

    @Override
    public abstract void putFloat(long var1, float var3);

    @Override
    public abstract void putDouble(long var1, double var3);

    @Override
    public abstract void putBinary(long var1, Binary var3);

    @Override
    public abstract void putBoolean(long var1, boolean var3);

    @Override
    public abstract void putAlignedRow(long var1, Object[] var3);

    @Override
    public abstract void putLongs(long[] var1, long[] var2, BitMap var3, int var4, int var5);

    @Override
    public abstract void putInts(long[] var1, int[] var2, BitMap var3, int var4, int var5);

    @Override
    public abstract void putFloats(long[] var1, float[] var2, BitMap var3, int var4, int var5);

    @Override
    public abstract void putDoubles(long[] var1, double[] var2, BitMap var3, int var4, int var5);

    @Override
    public abstract void putBinaries(long[] var1, Binary[] var2, BitMap var3, int var4, int var5);

    @Override
    public abstract void putBooleans(long[] var1, boolean[] var2, BitMap var3, int var4, int var5);

    @Override
    public abstract void putAlignedTablet(long[] var1, Object[] var2, BitMap[] var3, int var4, int var5, TSStatus[] var6);

    @Override
    public abstract void writeNonAlignedPoint(long var1, Object var3);

    @Override
    public abstract void writeAlignedPoints(long var1, Object[] var3, List<IMeasurementSchema> var4);

    @Override
    public abstract void writeNonAlignedTablet(long[] var1, Object var2, BitMap var3, TSDataType var4, int var5, int var6);

    @Override
    public abstract void writeAlignedTablet(long[] var1, Object[] var2, BitMap[] var3, List<IMeasurementSchema> var4, int var5, int var6, TSStatus[] var7);

    @Override
    public abstract long count();

    @Override
    public abstract long rowCount();

    @Override
    public abstract IMeasurementSchema getSchema();

    @Override
    public abstract void sortTvListForFlush();

    @Override
    public abstract int delete(long var1, long var3);

    @Override
    public abstract IChunkWriter createIChunkWriter();

    @Override
    public abstract void encode(BlockingQueue<Object> var1, BatchEncodeInfo var2, long[] var3);

    @Override
    public abstract void release();

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract List<? extends TVList> getSortedList();

    @Override
    public abstract TVList getWorkingTVList();

    @Override
    public abstract void setWorkingTVList(TVList var1);

    @Override
    public abstract void serializeToWAL(IWALByteBufferView var1);

    @Override
    public abstract int serializedSize();
}

