/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IFileScanHandle;

public class QueryDataSourceForRegionScan
implements IQueryDataSource {
    private final List<IFileScanHandle> seqFileScanHandles;
    private final List<IFileScanHandle> unseqFileScanHandles;
    private final int unSeqSize;
    private int curIndex;

    public QueryDataSourceForRegionScan(List<IFileScanHandle> seqFileScanHandle, List<IFileScanHandle> unseqFileScanHandles) {
        this.seqFileScanHandles = seqFileScanHandle;
        this.unseqFileScanHandles = unseqFileScanHandles;
        this.unSeqSize = this.unseqFileScanHandles.size();
        this.curIndex = this.unSeqSize + this.seqFileScanHandles.size();
    }

    public List<IFileScanHandle> getSeqFileScanHandles() {
        return this.seqFileScanHandles;
    }

    public List<IFileScanHandle> getUnseqFileScanHandles() {
        return this.unseqFileScanHandles;
    }

    @Override
    public IQueryDataSource clone() {
        QueryDataSourceForRegionScan queryDataSourceForRegionScan = new QueryDataSourceForRegionScan(this.seqFileScanHandles, this.unseqFileScanHandles);
        return queryDataSourceForRegionScan;
    }

    public boolean hasNext() {
        return this.curIndex > 0;
    }

    public IFileScanHandle next() {
        --this.curIndex;
        if (this.curIndex >= this.unSeqSize) {
            return this.seqFileScanHandles.get(this.curIndex - this.unSeqSize);
        }
        return this.unseqFileScanHandles.get(this.curIndex);
    }

    public void releaseFileScanHandle() {
        if (this.curIndex >= this.unSeqSize) {
            this.seqFileScanHandles.set(this.curIndex - this.unSeqSize, null);
        } else {
            this.unseqFileScanHandles.set(this.curIndex, null);
        }
    }
}

