/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckpointFileUtils {
    public static final Pattern CHECKPOINT_FILE_NAME_PATTERN = Pattern.compile(String.format("%s(?<%s>\\d+)\\%s$", "_", "versionId", ".checkpoint"));

    public static boolean checkpointFilenameFilter(File dir, String name) {
        return CHECKPOINT_FILE_NAME_PATTERN.matcher(name).find();
    }

    public static File[] listAllCheckpointFiles(File dir) {
        return dir.listFiles(CheckpointFileUtils::checkpointFilenameFilter);
    }

    public static int parseVersionId(String filename) {
        Matcher matcher = CHECKPOINT_FILE_NAME_PATTERN.matcher(filename);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group("versionId"));
        }
        throw new RuntimeException("Invalid checkpoint file name: " + filename);
    }

    public static void descSortByVersionId(File[] checkpointFiles) {
        Arrays.sort(checkpointFiles, Comparator.comparingInt(file -> CheckpointFileUtils.parseVersionId(((File)file).getName())).reversed());
    }

    public static String getLogFileName(long version) {
        return "_" + version + ".checkpoint";
    }
}

