/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALReader;

public class WALPrintTool {
    public void print(File file) throws IOException {
        Stack<File> stack = new Stack<File>();
        if (file.exists()) {
            stack.push(file);
        } else {
            System.out.println("The initial file does not exist");
        }
        while (!stack.isEmpty()) {
            File f = (File)stack.pop();
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                if (files == null) continue;
                for (File child : files) {
                    stack.push(child);
                }
                continue;
            }
            if (!f.getName().endsWith(".wal")) continue;
            this.doPrint(f);
        }
    }

    private void doPrint(File file) throws IOException {
        System.out.printf("-----------------%s---------------%n", file.getAbsoluteFile());
        try (WALReader reader = new WALReader(file);){
            long walCurrentReadOffset = reader.getWALCurrentReadOffset();
            while (reader.hasNext()) {
                WALEntry entry = reader.next();
                System.out.printf("%d\t%s%n", walCurrentReadOffset, entry.toString());
                walCurrentReadOffset = reader.getWALCurrentReadOffset();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: WALPrintTool <file>");
            return;
        }
        WALPrintTool tool = new WALPrintTool();
        tool.print(new File(args[0]));
    }
}

