/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.table.TsFileInsertionEventTableParser;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReqV2;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadTreeStatementDataTypeConvertExecutionVisitor;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTableStatementDataTypeConvertExecutionVisitor
extends AstVisitor<Optional<TSStatus>, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTableStatementDataTypeConvertExecutionVisitor.class);
    private final StatementExecutor statementExecutor;

    public LoadTableStatementDataTypeConvertExecutionVisitor(StatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TSStatus> visitLoadTsFile(LoadTsFile loadTsFileStatement, String databaseName) {
        if (Objects.isNull(databaseName)) {
            LOGGER.warn("Database name is unexpectedly null for LoadTsFileStatement: {}. Skip data type conversion.", (Object)loadTsFileStatement);
            return Optional.empty();
        }
        LOGGER.info("Start data type conversion for LoadTsFileStatement: {}.", (Object)loadTsFileStatement);
        for (File file : loadTsFileStatement.getTsFiles()) {
            try (TsFileInsertionEventTableParser parser = new TsFileInsertionEventTableParser(file, new TablePattern(true, null, null), Long.MIN_VALUE, Long.MAX_VALUE, null, "root", null);){
                for (TabletInsertionEvent tabletInsertionEvent : parser.toTabletInsertionEvents()) {
                    PipeRawTabletInsertionEvent rawTabletInsertionEvent;
                    LoadConvertedInsertTabletStatement statement;
                    if (!(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) || LoadTreeStatementDataTypeConvertExecutionVisitor.handleTSStatus(this.executeInsertTabletWithRetry(statement = new LoadConvertedInsertTabletStatement(PipeTransferTabletRawReqV2.toTPipeTransferRawReq((rawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent).convertToTablet(), rawTabletInsertionEvent.isAligned(), databaseName).constructStatement(), loadTsFileStatement.isConvertOnTypeMismatch()), databaseName), loadTsFileStatement)) continue;
                    Optional<TSStatus> optional = Optional.empty();
                    return optional;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to convert data type for LoadTsFileStatement: {}.", (Object)loadTsFileStatement, (Object)e);
                return Optional.empty();
            }
        }
        if (loadTsFileStatement.isDeleteAfterLoad()) {
            loadTsFileStatement.getTsFiles().forEach(tsfile -> {
                FileUtils.deleteQuietly((File)tsfile);
                String tsFilePath = tsfile.getAbsolutePath();
                FileUtils.deleteQuietly((File)new File(tsFilePath + ".resource"));
                FileUtils.deleteQuietly((File)new File(tsFilePath + ".mods"));
                FileUtils.deleteQuietly((File)new File(tsFilePath + ".mods2"));
            });
        }
        LOGGER.info("Data type conversion for LoadTsFileStatement {} is successful.", (Object)loadTsFileStatement);
        return Optional.of(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
    }

    private TSStatus executeInsertTabletWithRetry(LoadConvertedInsertTabletStatement statement, String databaseName) {
        TSStatus result;
        try {
            result = statement.accept(LoadTsFileDataTypeConverter.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement, databaseName));
            for (int i = 0; i < 5 && result.getCode() == TSStatusCode.LOAD_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode(); ++i) {
                Thread.sleep(100L * (long)(i + 1));
                result = statement.accept(LoadTsFileDataTypeConverter.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement, databaseName));
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            result = statement.accept(LoadTsFileDataTypeConverter.STATEMENT_EXCEPTION_VISITOR, e);
        }
        return result;
    }

    @FunctionalInterface
    public static interface StatementExecutor {
        public TSStatus execute(Statement var1, String var2);
    }
}

