/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.splitter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileData;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileDataType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeletionData
implements TsFileData {
    private final ModEntry deletion;

    public DeletionData(ModEntry deletion) {
        this.deletion = deletion;
    }

    @Override
    public long getDataSize() {
        return this.deletion.serializedSize();
    }

    public void writeToModificationFile(ModificationFile modificationFile) throws IOException {
        modificationFile.write(this.deletion);
    }

    @Override
    public TsFileDataType getType() {
        return TsFileDataType.DELETION;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.getType().ordinal(), (OutputStream)stream);
        this.deletion.serialize(stream);
    }

    public static DeletionData deserialize(InputStream stream) throws IllegalPathException, IOException {
        return new DeletionData(ModEntry.createFrom(new DataInputStream(stream)));
    }
}

