/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;

public class PublishRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=824");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=826");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=825");
    private final RequestHeader requestHeader;
    private final SubscriptionAcknowledgement[] subscriptionAcknowledgements;

    public PublishRequest(RequestHeader requestHeader, SubscriptionAcknowledgement[] subscriptionAcknowledgements) {
        this.requestHeader = requestHeader;
        this.subscriptionAcknowledgements = subscriptionAcknowledgements;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        return this.subscriptionAcknowledgements;
    }

    protected PublishRequest(PublishRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((PublishRequestBuilder)b).requestHeader;
        this.subscriptionAcknowledgements = ((PublishRequestBuilder)b).subscriptionAcknowledgements;
    }

    public static PublishRequestBuilder<?, ?> builder() {
        return new PublishRequestBuilderImpl();
    }

    public PublishRequestBuilder<?, ?> toBuilder() {
        return new PublishRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getSubscriptionAcknowledgements(), other.getSubscriptionAcknowledgements());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublishRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSubscriptionAcknowledgements());
        return result;
    }

    @Override
    public String toString() {
        return "PublishRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionAcknowledgements=" + Arrays.deepToString(this.getSubscriptionAcknowledgements()) + ")";
    }

    private static final class PublishRequestBuilderImpl
    extends PublishRequestBuilder<PublishRequest, PublishRequestBuilderImpl> {
        private PublishRequestBuilderImpl() {
        }

        @Override
        protected PublishRequestBuilderImpl self() {
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }
    }

    public static abstract class PublishRequestBuilder<C extends PublishRequest, B extends PublishRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private SubscriptionAcknowledgement[] subscriptionAcknowledgements;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PublishRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(PublishRequest instance, PublishRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionAcknowledgements(instance.subscriptionAcknowledgements);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionAcknowledgements(SubscriptionAcknowledgement[] subscriptionAcknowledgements) {
            this.subscriptionAcknowledgements = subscriptionAcknowledgements;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PublishRequest.PublishRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionAcknowledgements=" + Arrays.deepToString(this.subscriptionAcknowledgements) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<PublishRequest> {
        @Override
        public Class<PublishRequest> getType() {
            return PublishRequest.class;
        }

        @Override
        public PublishRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            SubscriptionAcknowledgement[] subscriptionAcknowledgements = (SubscriptionAcknowledgement[])decoder.readStructArray("SubscriptionAcknowledgements", SubscriptionAcknowledgement.TYPE_ID);
            return new PublishRequest(requestHeader, subscriptionAcknowledgements);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, PublishRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("SubscriptionAcknowledgements", (Object[])value.getSubscriptionAcknowledgements(), SubscriptionAcknowledgement.TYPE_ID);
        }
    }
}

