/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.utils;

import java.util.function.Function;
import org.apache.ratis.util.TimeDuration;

public class RetryPolicy<RESP> {
    private final Function<RESP, Boolean> retryHandler;
    private final int maxAttempts;
    private final boolean exponentialBackoff;
    private final TimeDuration waitTime;
    private final TimeDuration maxWaitTime;

    public RetryPolicy(Function<RESP, Boolean> retryHandler, int maxAttempts, TimeDuration waitTime, TimeDuration maxWaitTime, boolean exponentialBackoff) {
        this.retryHandler = retryHandler;
        this.maxAttempts = maxAttempts;
        this.waitTime = waitTime;
        this.maxWaitTime = maxWaitTime;
        this.exponentialBackoff = exponentialBackoff;
    }

    boolean shouldRetry(RESP resp) {
        return this.retryHandler.apply(resp);
    }

    boolean shoudAttempt(int attempt) {
        return this.maxAttempts == -1 || attempt < this.maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public TimeDuration getWaitTime(int attempt) {
        if (this.exponentialBackoff) {
            TimeDuration sleepTime = this.waitTime.multiply(Math.pow(2.0, attempt));
            return this.maxWaitTime.getDuration() != 0L && sleepTime.compareTo(this.maxWaitTime) > 0 ? this.maxWaitTime : sleepTime;
        }
        return this.waitTime;
    }

    public static <RESP> RetryPolicyBuilder<RESP> newBuilder() {
        return new RetryPolicyBuilder();
    }

    public static class RetryPolicyBuilder<RESP> {
        private Function<RESP, Boolean> retryHandler = r -> false;
        private int maxAttempts = 0;
        public boolean exponentialBackoff = false;
        private TimeDuration waitTime = TimeDuration.ZERO;
        private TimeDuration maxWaitTime = TimeDuration.ZERO;

        public RetryPolicyBuilder<RESP> setRetryHandler(Function<RESP, Boolean> retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public RetryPolicyBuilder<RESP> setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public RetryPolicyBuilder<RESP> setWaitTime(TimeDuration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public RetryPolicyBuilder<RESP> setMaxWaitTime(TimeDuration maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public RetryPolicyBuilder<RESP> setExponentialBackoff(boolean exponentialBackoff) {
            this.exponentialBackoff = exponentialBackoff;
            return this;
        }

        public RetryPolicy<RESP> build() {
            return new RetryPolicy<RESP>(this.retryHandler, this.maxAttempts, this.waitTime, this.maxWaitTime, this.exponentialBackoff);
        }
    }
}

