/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRefreshOperation
implements SessionOperation<Object> {
    private static final Logger log = LoggerFactory.getLogger(ItemRefreshOperation.class);
    private final ItemState state;
    private final boolean keepChanges;

    public ItemRefreshOperation(ItemState state, boolean keepChanges) {
        this.state = state;
        this.keepChanges = keepChanges;
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        if (this.keepChanges) {
            return this;
        }
        SessionItemStateManager stateMgr = context.getItemStateManager();
        if (this.state.getParentId() == null) {
            stateMgr.disposeAllTransientItemStates();
            return this;
        }
        ArrayList<ItemState> transientStates = new ArrayList<ItemState>();
        if (this.state.isTransient()) {
            switch (this.state.getStatus()) {
                case 6: {
                    transientStates.add(this.state);
                    break;
                }
                case 2: {
                    if (!this.state.getParentId().equals(this.state.getOverlayedState().getParentId())) {
                        throw new RepositoryException("Cannot refresh a moved item, try refreshing the parent: " + String.valueOf(this));
                    }
                    transientStates.add(this.state);
                    break;
                }
                case 4: {
                    throw new RepositoryException("Cannot refresh a new item: " + String.valueOf(this));
                }
                default: {
                    log.warn("Unexpected item state status {} of {}", (Object)this.state.getStatus(), (Object)this);
                }
            }
        }
        if (this.state.isNode()) {
            block8: for (ItemState transientState : stateMgr.getDescendantTransientItemStates(this.state.getId())) {
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: 
                    case 6: {
                        transientStates.add(transientState);
                        continue block8;
                    }
                }
                log.debug("unexpected state status ({})", (Object)transientState.getStatus());
            }
        }
        for (ItemState transientState : transientStates) {
            stateMgr.disposeTransientItemState(transientState);
        }
        if (this.state.isNode()) {
            for (ItemState descendant : stateMgr.getDescendantTransientItemStatesInAttic(this.state.getId())) {
                stateMgr.disposeTransientItemStateInAttic(descendant);
            }
        }
        return this;
    }

    public String toString() {
        return "item.refresh(" + this.keepChanges + ")";
    }
}

