/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.PropertyValue;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;

abstract class AbstractRow
implements Row {
    private final Map<String, PropertyValue> columns;
    private final OperandEvaluator evaluator;

    protected AbstractRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator) {
        this.columns = columns;
        this.evaluator = evaluator;
    }

    @Override
    public Value[] getValues() throws RepositoryException {
        Value[] values = new Value[this.columns.size()];
        int i = 0;
        for (String columnName : this.columns.keySet()) {
            values[i++] = this.getValue(columnName);
        }
        return values;
    }

    @Override
    public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
        Operand operand = this.columns.get(columnName);
        if (operand != null) {
            return this.evaluator.getValue(operand, this);
        }
        throw new ItemNotFoundException("Column " + columnName + " is not included in this row");
    }

    @Override
    public String getPath() throws RepositoryException {
        Node node = this.getNode();
        if (node != null) {
            return node.getPath();
        }
        return null;
    }

    @Override
    public String getPath(String selectorName) throws RepositoryException {
        Node node = this.getNode(selectorName);
        if (node != null) {
            return node.getPath();
        }
        return null;
    }
}

