/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.UpperCase;
import org.apache.jackrabbit.core.query.lucene.join.ConstraintSplitInfo;

class ConstraintSplitter {
    private final QueryObjectModelFactory factory;
    private final Set<String> leftSelectors;
    private final Set<String> rightSelectors;
    private final ConstraintSplitInfo constraintSplitInfo;

    public ConstraintSplitter(Constraint constraint, QueryObjectModelFactory factory, Set<String> leftSelectors, Set<String> rightSelectors, Join join) throws RepositoryException {
        this.factory = factory;
        this.leftSelectors = leftSelectors;
        this.rightSelectors = rightSelectors;
        this.constraintSplitInfo = new ConstraintSplitInfo(this.factory, join);
        if (constraint != null) {
            this.split(this.constraintSplitInfo, constraint);
        }
    }

    private void split(ConstraintSplitInfo constraintSplitInfo, Constraint constraint) throws RepositoryException {
        if (constraint instanceof Not) {
            this.splitNot(constraintSplitInfo, (Not)constraint);
        } else if (constraint instanceof And) {
            And and = (And)constraint;
            this.split(constraintSplitInfo, and.getConstraint1());
            this.split(constraintSplitInfo, and.getConstraint2());
        } else if (constraint instanceof Or) {
            if (this.isReferencingBothSides(this.getSelectorNames(constraint))) {
                Or or = (Or)constraint;
                constraintSplitInfo.splitOr();
                this.split(constraintSplitInfo.getLeftInnerConstraints(), or.getConstraint1());
                this.split(constraintSplitInfo.getRightInnerConstraints(), or.getConstraint2());
            } else {
                this.splitBySelectors(constraintSplitInfo, constraint, this.getSelectorNames(constraint));
            }
        } else {
            this.splitBySelectors(constraintSplitInfo, constraint, this.getSelectorNames(constraint));
        }
    }

    private boolean isReferencingBothSides(Set<String> selectors) {
        return !this.leftSelectors.containsAll(selectors) && !this.rightSelectors.containsAll(selectors);
    }

    private void splitNot(ConstraintSplitInfo constraintSplitInfo, Not not) throws RepositoryException {
        Constraint constraint = not.getConstraint();
        if (constraint instanceof Not) {
            this.split(constraintSplitInfo, ((Not)constraint).getConstraint());
        } else if (constraint instanceof And) {
            And and = (And)constraint;
            this.split(constraintSplitInfo, this.factory.or(this.factory.not(and.getConstraint1()), this.factory.not(and.getConstraint2())));
        } else if (constraint instanceof Or) {
            Or or = (Or)constraint;
            this.split(constraintSplitInfo, this.factory.and(this.factory.not(or.getConstraint1()), this.factory.not(or.getConstraint2())));
        } else {
            this.splitBySelectors(constraintSplitInfo, not, this.getSelectorNames(constraint));
        }
    }

    private void splitBySelectors(ConstraintSplitInfo constraintSplitInfo, Constraint constraint, Set<String> selectors) throws UnsupportedRepositoryOperationException {
        if (this.leftSelectors.containsAll(selectors)) {
            constraintSplitInfo.addLeftConstraint(constraint);
        } else if (this.rightSelectors.containsAll(selectors)) {
            constraintSplitInfo.addRightConstraint(constraint);
        } else {
            throw new UnsupportedRepositoryOperationException("Unable to split a constraint that references both sides of a join: " + String.valueOf(constraint));
        }
    }

    private Set<String> getSelectorNames(Constraint constraint) throws UnsupportedRepositoryOperationException {
        if (constraint instanceof And) {
            And and = (And)constraint;
            return this.getSelectorNames(and.getConstraint1(), and.getConstraint2());
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            return this.getSelectorNames(or.getConstraint1(), or.getConstraint2());
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            return this.getSelectorNames(not.getConstraint());
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence pe = (PropertyExistence)constraint;
            return Collections.singleton(pe.getSelectorName());
        }
        if (constraint instanceof Comparison) {
            Comparison c = (Comparison)constraint;
            return Collections.singleton(this.getSelectorName(c.getOperand1()));
        }
        if (constraint instanceof SameNode) {
            SameNode sn = (SameNode)constraint;
            return Collections.singleton(sn.getSelectorName());
        }
        if (constraint instanceof ChildNode) {
            ChildNode cn = (ChildNode)constraint;
            return Collections.singleton(cn.getSelectorName());
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode dn = (DescendantNode)constraint;
            return Collections.singleton(dn.getSelectorName());
        }
        if (constraint instanceof FullTextSearch) {
            FullTextSearch fts = (FullTextSearch)constraint;
            return Collections.singleton(fts.getSelectorName());
        }
        throw new UnsupportedRepositoryOperationException("Unknown constraint type: " + String.valueOf(constraint));
    }

    private Set<String> getSelectorNames(Constraint a, Constraint b) throws UnsupportedRepositoryOperationException {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.getSelectorNames(a));
        set.addAll(this.getSelectorNames(b));
        return set;
    }

    private String getSelectorName(DynamicOperand operand) throws UnsupportedRepositoryOperationException {
        if (operand instanceof FullTextSearchScore) {
            FullTextSearchScore ftss = (FullTextSearchScore)operand;
            return ftss.getSelectorName();
        }
        if (operand instanceof Length) {
            Length length = (Length)operand;
            return this.getSelectorName(length.getPropertyValue());
        }
        if (operand instanceof LowerCase) {
            LowerCase lower = (LowerCase)operand;
            return this.getSelectorName(lower.getOperand());
        }
        if (operand instanceof NodeLocalName) {
            NodeLocalName local = (NodeLocalName)operand;
            return local.getSelectorName();
        }
        if (operand instanceof NodeName) {
            NodeName name = (NodeName)operand;
            return name.getSelectorName();
        }
        if (operand instanceof PropertyValue) {
            PropertyValue value = (PropertyValue)operand;
            return value.getSelectorName();
        }
        if (operand instanceof UpperCase) {
            UpperCase upper = (UpperCase)operand;
            return this.getSelectorName(upper.getOperand());
        }
        throw new UnsupportedRepositoryOperationException("Unknown dynamic operand type: " + String.valueOf(operand));
    }

    public ConstraintSplitInfo getConstraintSplitInfo() {
        return this.constraintSplitInfo;
    }
}

