/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.commons.xml.XMLFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DOMBuilder {
    private static final DocumentBuilderFactory BUILDER_FACTORY = XMLFactories.safeDocumentBuilderFactory();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final Document document;
    private Element current;

    public DOMBuilder(String name) throws ParserConfigurationException {
        DocumentBuilder builder = BUILDER_FACTORY.newDocumentBuilder();
        this.document = builder.newDocument();
        this.current = this.document.createElement(name);
        this.document.appendChild(this.current);
    }

    public void write(OutputStream xml) throws IOException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.transform(new DOMSource(this.document), new StreamResult(xml));
        }
        catch (TransformerConfigurationException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (TransformerException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void startElement(String name) {
        Element element = this.document.createElement(name);
        this.current.appendChild(element);
        this.current = element;
    }

    public void endElement() {
        this.current = (Element)this.current.getParentNode();
    }

    public void setAttribute(String name, String value) {
        this.current.setAttribute(name, value);
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void addContent(String content) {
        this.current.appendChild(this.document.createTextNode(content));
    }

    public void addContentElement(String name, String content) {
        this.startElement(name);
        this.addContent(content);
        this.endElement();
    }
}

