/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Workspace;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Clone
implements Command {
    private static Log log = LogFactory.getLog(Clone.class);
    private String srcWorkspaceKey = "scrWorkspace";
    private String srcAbsPathKey = "srcAbsPath";
    private String destAbsPathKey = "destAbsPath";
    private String removeExistingKey = "removeExisting";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String srcWorkspace = (String)ctx.get(this.srcWorkspaceKey);
        String srcAbsPath = (String)ctx.get(this.srcAbsPathKey);
        String destAbsPath = (String)ctx.get(this.destAbsPathKey);
        Boolean removeExisting = Boolean.valueOf((String)ctx.get(this.removeExistingKey));
        Workspace w = CommandHelper.getSession(ctx).getWorkspace();
        if (log.isDebugEnabled()) {
            log.debug("cloning node. from [" + srcWorkspace + ":" + srcAbsPath + "] to [" + w.getName() + ":" + destAbsPath + "]");
        }
        w.clone(srcWorkspace, srcAbsPath, destAbsPath, removeExisting);
        return false;
    }

    public String getDestAbsPathKey() {
        return this.destAbsPathKey;
    }

    public void setDestAbsPathKey(String destAbsPathKey) {
        this.destAbsPathKey = destAbsPathKey;
    }

    public String getRemoveExistingKey() {
        return this.removeExistingKey;
    }

    public void setRemoveExistingKey(String removeExistingKey) {
        this.removeExistingKey = removeExistingKey;
    }

    public String getSrcAbsPathKey() {
        return this.srcAbsPathKey;
    }

    public void setSrcAbsPathKey(String srcAbsPathKey) {
        this.srcAbsPathKey = srcAbsPathKey;
    }

    public String getSrcWorkspaceKey() {
        return this.srcWorkspaceKey;
    }

    public void setSrcWorkspaceKey(String srcWorkspaceKey) {
        this.srcWorkspaceKey = srcWorkspaceKey;
    }
}

